package com.mobibrw.myapplication;

import androidx.appcompat.app.AppCompatActivity;

import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;

public class MainActivity extends AppCompatActivity {

    private final static int SINGLE_INSTANCE = 1;
    private final static int SINGLE_TOP = 2;

    private void startSingleInstanceActivity() {
        final Intent intent = new Intent(this, SingleInstanceActivity.class);
        //intent.addFlags(Intent.FLAG_ACTIVITY_BROUGHT_TO_FRONT | Intent.FLAG_ACTIVITY_REORDER_TO_FRONT);
        startActivityForResult(intent, SINGLE_INSTANCE);
    }

    private void startSingleTopActivity() {
        final Intent intent = new Intent(this, SingleTopActivity.class);
        //intent.addFlags(Intent.FLAG_ACTIVITY_BROUGHT_TO_FRONT | Intent.FLAG_ACTIVITY_REORDER_TO_FRONT);
        startActivityForResult(intent, SINGLE_TOP);
    }

    private void startSingleInstanceWithFlagsActivity() {
        final Intent intent = new Intent(this, SingleInstanceActivity.class);
        intent.addFlags(Intent.FLAG_ACTIVITY_BROUGHT_TO_FRONT | Intent.FLAG_ACTIVITY_REORDER_TO_FRONT);
        startActivityForResult(intent, SINGLE_INSTANCE);
    }

    private void startSingleTopWithFlagsActivity() {
        final Intent intent = new Intent(this, SingleTopActivity.class);
        intent.addFlags(Intent.FLAG_ACTIVITY_BROUGHT_TO_FRONT | Intent.FLAG_ACTIVITY_REORDER_TO_FRONT);
        startActivityForResult(intent, SINGLE_TOP);
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);

        Button btnSingleTop = findViewById(R.id.SingleTop);
        btnSingleTop.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                startSingleTopActivity();
                startSingleTopActivity();
            }
        });
        Button btnSingleInstance = findViewById(R.id.SingleInstance);
        btnSingleInstance.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                startSingleInstanceActivity();
                startSingleInstanceActivity();
            }
        });

        Button btnSingleTopWithFlags = findViewById(R.id.SingleTopWithFlags);
        btnSingleTopWithFlags.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                startSingleTopWithFlagsActivity();
                startSingleTopWithFlagsActivity();
            }
        });
        Button btnSingleInstanceWithFlags = findViewById(R.id.SingleInstanceWithFlags);
        btnSingleInstanceWithFlags.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                startSingleInstanceWithFlagsActivity();
                startSingleInstanceWithFlagsActivity();
            }
        });
    }
}