package com.mobibrw.viewpager;

import android.app.Activity;
import android.os.Bundle;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.TextView;

import java.util.Random;

public class MainActivity extends Activity {

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);

        final ViewPager viewPager = (ViewPager)findViewById(R.id.viewPager);
        viewPager.setAdapter(new PagerAdapter() {
            @Override
            public int getCount() {
                return Integer.MAX_VALUE;
            }

            @Override
            public boolean isViewFromObject(View view, Object object) {
                return view == object;
            }

            @Override
            public void destroyItem(ViewGroup container, int position, Object object) {
                container.removeView((View) object);
            }

            @Override
            public Object instantiateItem(ViewGroup container, final int position) {
                final View view = LayoutInflater.from(MainActivity.this).inflate(R.layout.pager_view, null);
                final TextView tv = (TextView)view.findViewById(R.id.text);
                tv.setText("" + position);
                container.addView(view);
                return view;
            }
        });

        final Button btnCmd = (Button)findViewById(R.id.btnCmd);
        btnCmd.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                Random rdm = new Random(System.currentTimeMillis());
                int rd = Math.abs(rdm.nextInt())%700 + 1;
                viewPager.setCurrentItem(rd);
            }
        });
    }
}
