/*
 * Decompiled with CFR 0.152.
 */
package android.support.test.uiautomator;

import android.content.Context;
import android.graphics.Point;
import android.graphics.Rect;
import android.support.test.uiautomator.Direction;
import android.support.test.uiautomator.PointerGesture;
import android.support.test.uiautomator.UiDevice;
import android.view.ViewConfiguration;

class Gestures {
    private static Gestures sInstance;
    private static final int INNER = 0;
    private static final int OUTER = 1;
    private static final int INNER_MARGIN = 5;
    private ViewConfiguration mViewConfig;

    private Gestures(ViewConfiguration config) {
        this.mViewConfig = config;
    }

    public static Gestures getInstance(UiDevice device) {
        if (sInstance == null) {
            Context context = device.getAutomatorBridge().getContext();
            sInstance = new Gestures(ViewConfiguration.get((Context)context));
        }
        return sInstance;
    }

    public PointerGesture click(Point point) {
        return new PointerGesture(point);
    }

    public PointerGesture longClick(Point point) {
        Gestures gestures = this;
        return this.click(point).pause(gestures.mViewConfig.getLongPressTimeout());
    }

    public PointerGesture swipe(Point start, Point end, int speed) {
        return this.click(start).move(end, speed);
    }

    public PointerGesture swipeRect(Rect area, Direction direction, float percent, int speed) {
        Point end;
        Point start;
        switch (direction) {
            case LEFT: {
                start = new Point(area.right, area.centerY());
                end = new Point(area.right - (int)((float)area.width() * percent), area.centerY());
                break;
            }
            case RIGHT: {
                start = new Point(area.left, area.centerY());
                end = new Point(area.left + (int)((float)area.width() * percent), area.centerY());
                break;
            }
            case UP: {
                start = new Point(area.centerX(), area.bottom);
                end = new Point(area.centerX(), area.bottom - (int)((float)area.height() * percent));
                break;
            }
            case DOWN: {
                start = new Point(area.centerX(), area.top);
                end = new Point(area.centerX(), area.top + (int)((float)area.height() * percent));
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
        return this.swipe(start, end, speed);
    }

    public PointerGesture drag(Point start, Point end, int speed) {
        return this.longClick(start).move(end, speed);
    }

    public PointerGesture[] pinchClose(Rect area, float percent, int speed) {
        Point[] bottomLeft = new Point[2];
        Point[] topRight = new Point[2];
        this.calcPinchCoordinates(area, percent, bottomLeft, topRight);
        return new PointerGesture[]{this.swipe(bottomLeft[1], bottomLeft[0], speed).pause(250L), this.swipe(topRight[1], topRight[0], speed).pause(250L)};
    }

    public PointerGesture[] pinchOpen(Rect area, float percent, int speed) {
        Point[] bottomLeft = new Point[2];
        Point[] topRight = new Point[2];
        this.calcPinchCoordinates(area, percent, bottomLeft, topRight);
        return new PointerGesture[]{this.swipe(bottomLeft[0], bottomLeft[1], speed), this.swipe(topRight[0], topRight[1], speed)};
    }

    private void calcPinchCoordinates(Rect area, float percent, Point[] bottomLeft, Point[] topRight) {
        int offsetX = (int)((float)((area.width() - 10) / 2) * percent);
        int offsetY = (int)((float)((area.height() - 10) / 2) * percent);
        bottomLeft[1] = new Point(area.left + 5, area.bottom - 5);
        topRight[1] = new Point(area.right - 5, area.top + 5);
        bottomLeft[0] = new Point(bottomLeft[1]);
        bottomLeft[0].offset(offsetX, -offsetY);
        topRight[0] = new Point(topRight[1]);
        topRight[0].offset(-offsetX, offsetY);
    }
}

