/*
 * Decompiled with CFR 0.152.
 */
package android.support.test.uiautomator;

import android.app.UiAutomation;
import android.graphics.Point;
import android.os.RemoteException;
import android.os.SystemClock;
import android.support.test.uiautomator.Configurator;
import android.support.test.uiautomator.UiAutomatorBridge;
import android.util.Log;
import android.view.InputEvent;
import android.view.KeyCharacterMap;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.accessibility.AccessibilityEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeoutException;

class InteractionController {
    private static final String LOG_TAG = InteractionController.class.getSimpleName();
    private static final boolean DEBUG = Log.isLoggable((String)LOG_TAG, (int)3);
    private final KeyCharacterMap mKeyCharacterMap = KeyCharacterMap.load((int)-1);
    private final UiAutomatorBridge mUiAutomatorBridge;
    private static final long REGULAR_CLICK_LENGTH = 100L;
    private long mDownTime;
    private static final int MOTION_EVENT_INJECTION_DELAY_MILLIS = 5;

    public InteractionController(UiAutomatorBridge bridge) {
        this.mUiAutomatorBridge = bridge;
    }

    private AccessibilityEvent runAndWaitForEvents(Runnable command, UiAutomation.AccessibilityEventFilter filter, long timeout) {
        try {
            return this.mUiAutomatorBridge.executeCommandAndWaitForAccessibilityEvent(command, filter, timeout);
        }
        catch (TimeoutException e) {
            Log.w((String)LOG_TAG, (String)"runAndwaitForEvents timed out waiting for events");
            return null;
        }
        catch (Exception e) {
            Log.e((String)LOG_TAG, (String)"exception from executeCommandAndWaitForAccessibilityEvent", (Throwable)e);
            return null;
        }
    }

    public boolean sendKeyAndWaitForEvent(final int keyCode, final int metaState, int eventType, long timeout) {
        Runnable command = new Runnable(){

            @Override
            public void run() {
                long eventTime = SystemClock.uptimeMillis();
                KeyEvent downEvent = new KeyEvent(eventTime, eventTime, 0, keyCode, 0, metaState, -1, 0, 0, 257);
                if (InteractionController.this.injectEventSync((InputEvent)downEvent)) {
                    KeyEvent upEvent = new KeyEvent(eventTime, eventTime, 1, keyCode, 0, metaState, -1, 0, 0, 257);
                    InteractionController.this.injectEventSync((InputEvent)upEvent);
                }
            }
        };
        return this.runAndWaitForEvents(command, new WaitForAnyEventPredicate(eventType), timeout) != null;
    }

    public boolean clickNoSync(int x, int y) {
        Log.d((String)LOG_TAG, (String)("clickNoSync (" + x + ", " + y + ")"));
        if (this.touchDown(x, y)) {
            SystemClock.sleep((long)100L);
            if (this.touchUp(x, y)) {
                return true;
            }
        }
        return false;
    }

    public boolean clickAndSync(int x, int y, long timeout) {
        String logString = String.format("clickAndSync(%d, %d)", x, y);
        Log.d((String)LOG_TAG, (String)logString);
        return this.runAndWaitForEvents(this.clickRunnable(x, y), new WaitForAnyEventPredicate(2052), timeout) != null;
    }

    public boolean clickAndWaitForNewWindow(int x, int y, long timeout) {
        String logString = String.format("clickAndWaitForNewWindow(%d, %d)", x, y);
        Log.d((String)LOG_TAG, (String)logString);
        return this.runAndWaitForEvents(this.clickRunnable(x, y), new WaitForAllEventPredicate(2080), timeout) != null;
    }

    private Runnable clickRunnable(final int x, final int y) {
        return new Runnable(){

            @Override
            public void run() {
                if (InteractionController.this.touchDown(x, y)) {
                    SystemClock.sleep((long)100L);
                    InteractionController.this.touchUp(x, y);
                }
            }
        };
    }

    private Runnable longTapRunnable(final int x, final int y) {
        return new Runnable(){

            @Override
            public void run() {
                if (InteractionController.this.touchDown(x, y)) {
                    SystemClock.sleep((long)InteractionController.this.mUiAutomatorBridge.getSystemLongPressTime());
                    InteractionController.this.touchUp(x, y);
                }
            }
        };
    }

    public boolean longTapNoSync(int x, int y) {
        if (DEBUG) {
            Log.d((String)LOG_TAG, (String)("longTapNoSync (" + x + ", " + y + ")"));
        }
        if (this.touchDown(x, y)) {
            SystemClock.sleep((long)this.mUiAutomatorBridge.getSystemLongPressTime());
            if (this.touchUp(x, y)) {
                return true;
            }
        }
        return false;
    }

    public boolean longTapAndSync(int x, int y, long timeout) {
        String logString = String.format("clickAndSync(%d, %d)", x, y);
        Log.d((String)LOG_TAG, (String)logString);
        return this.runAndWaitForEvents(this.longTapRunnable(x, y), new WaitForAnyEventPredicate(2052), timeout) != null;
    }

    private boolean touchDown(int x, int y) {
        if (DEBUG) {
            Log.d((String)LOG_TAG, (String)("touchDown (" + x + ", " + y + ")"));
        }
        this.mDownTime = SystemClock.uptimeMillis();
        MotionEvent event = MotionEvent.obtain((long)this.mDownTime, (long)this.mDownTime, (int)0, (float)x, (float)y, (int)0);
        event.setSource(4098);
        return this.injectEventSync((InputEvent)event);
    }

    private boolean touchUp(int x, int y) {
        if (DEBUG) {
            Log.d((String)LOG_TAG, (String)("touchUp (" + x + ", " + y + ")"));
        }
        long eventTime = SystemClock.uptimeMillis();
        MotionEvent event = MotionEvent.obtain((long)this.mDownTime, (long)eventTime, (int)1, (float)x, (float)y, (int)0);
        event.setSource(4098);
        this.mDownTime = 0L;
        return this.injectEventSync((InputEvent)event);
    }

    private boolean touchMove(int x, int y) {
        if (DEBUG) {
            Log.d((String)LOG_TAG, (String)("touchMove (" + x + ", " + y + ")"));
        }
        long eventTime = SystemClock.uptimeMillis();
        MotionEvent event = MotionEvent.obtain((long)this.mDownTime, (long)eventTime, (int)2, (float)x, (float)y, (int)0);
        event.setSource(4098);
        return this.injectEventSync((InputEvent)event);
    }

    public boolean scrollSwipe(final int downX, final int downY, final int upX, final int upY, final int steps) {
        Log.d((String)LOG_TAG, (String)("scrollSwipe (" + downX + ", " + downY + ", " + upX + ", " + upY + ", " + steps + ")"));
        Runnable command = new Runnable(){

            @Override
            public void run() {
                InteractionController.this.swipe(downX, downY, upX, upY, steps);
            }
        };
        ArrayList<AccessibilityEvent> events = new ArrayList<AccessibilityEvent>();
        this.runAndWaitForEvents(command, new EventCollectingPredicate(4096, events), Configurator.getInstance().getScrollAcknowledgmentTimeout());
        AccessibilityEvent event = this.getLastMatchingEvent(events, 4096);
        if (event == null) {
            this.recycleAccessibilityEvents(events);
            return false;
        }
        boolean foundEnd = false;
        if (event.getFromIndex() != -1 && event.getToIndex() != -1 && event.getItemCount() != -1) {
            foundEnd = event.getFromIndex() == 0 || event.getItemCount() - 1 == event.getToIndex();
            Log.d((String)LOG_TAG, (String)("scrollSwipe reached scroll end: " + foundEnd));
        } else if (event.getScrollX() != -1 && event.getScrollY() != -1) {
            if (downX == upX) {
                foundEnd = event.getScrollY() == 0 || event.getScrollY() == event.getMaxScrollY();
                Log.d((String)LOG_TAG, (String)("Vertical scrollSwipe reached scroll end: " + foundEnd));
            } else if (downY == upY) {
                foundEnd = event.getScrollX() == 0 || event.getScrollX() == event.getMaxScrollX();
                Log.d((String)LOG_TAG, (String)("Horizontal scrollSwipe reached scroll end: " + foundEnd));
            }
        }
        this.recycleAccessibilityEvents(events);
        return !foundEnd;
    }

    private AccessibilityEvent getLastMatchingEvent(List<AccessibilityEvent> events, int type) {
        for (int x = events.size(); x > 0; --x) {
            AccessibilityEvent event = events.get(x - 1);
            if (event.getEventType() != type) continue;
            return event;
        }
        return null;
    }

    private void recycleAccessibilityEvents(List<AccessibilityEvent> events) {
        for (AccessibilityEvent event : events) {
            event.recycle();
        }
        events.clear();
    }

    public boolean swipe(int downX, int downY, int upX, int upY, int steps) {
        return this.swipe(downX, downY, upX, upY, steps, false);
    }

    public boolean swipe(int downX, int downY, int upX, int upY, int steps, boolean drag) {
        boolean ret = false;
        int swipeSteps = steps;
        double xStep = 0.0;
        double yStep = 0.0;
        if (swipeSteps == 0) {
            swipeSteps = 1;
        }
        xStep = (double)(upX - downX) / (double)swipeSteps;
        yStep = (double)(upY - downY) / (double)swipeSteps;
        ret = this.touchDown(downX, downY);
        if (drag) {
            SystemClock.sleep((long)this.mUiAutomatorBridge.getSystemLongPressTime());
        }
        for (int i = 1; i < swipeSteps && (ret &= this.touchMove(downX + (int)(xStep * (double)i), downY + (int)(yStep * (double)i))); ++i) {
            SystemClock.sleep((long)5L);
        }
        if (drag) {
            SystemClock.sleep((long)100L);
        }
        return ret &= this.touchUp(upX, upY);
    }

    public boolean swipe(Point[] segments, int segmentSteps) {
        boolean ret = false;
        int swipeSteps = segmentSteps;
        double xStep = 0.0;
        double yStep = 0.0;
        if (segmentSteps == 0) {
            segmentSteps = 1;
        }
        if (segments.length == 0) {
            return false;
        }
        ret = this.touchDown(segments[0].x, segments[0].y);
        for (int seg = 0; seg < segments.length; ++seg) {
            if (seg + 1 >= segments.length) continue;
            xStep = (double)(segments[seg + 1].x - segments[seg].x) / (double)segmentSteps;
            yStep = (double)(segments[seg + 1].y - segments[seg].y) / (double)segmentSteps;
            for (int i = 1; i < swipeSteps && (ret &= this.touchMove(segments[seg].x + (int)(xStep * (double)i), segments[seg].y + (int)(yStep * (double)i))); ++i) {
                SystemClock.sleep((long)5L);
            }
        }
        return ret &= this.touchUp(segments[segments.length - 1].x, segments[segments.length - 1].y);
    }

    public boolean sendText(String text) {
        KeyEvent[] events;
        if (DEBUG) {
            Log.d((String)LOG_TAG, (String)("sendText (" + text + ")"));
        }
        if ((events = this.mKeyCharacterMap.getEvents(text.toCharArray())) != null) {
            long keyDelay = Configurator.getInstance().getKeyInjectionDelay();
            for (KeyEvent event2 : events) {
                KeyEvent event = KeyEvent.changeTimeRepeat((KeyEvent)event2, (long)SystemClock.uptimeMillis(), (int)0);
                if (!this.injectEventSync((InputEvent)event)) {
                    return false;
                }
                SystemClock.sleep((long)keyDelay);
            }
        }
        return true;
    }

    public boolean sendKey(int keyCode, int metaState) {
        KeyEvent upEvent;
        long eventTime;
        KeyEvent downEvent;
        if (DEBUG) {
            Log.d((String)LOG_TAG, (String)("sendKey (" + keyCode + ", " + metaState + ")"));
        }
        return this.injectEventSync((InputEvent)(downEvent = new KeyEvent(eventTime = SystemClock.uptimeMillis(), eventTime, 0, keyCode, 0, metaState, -1, 0, 0, 257))) && this.injectEventSync((InputEvent)(upEvent = new KeyEvent(eventTime, eventTime, 1, keyCode, 0, metaState, -1, 0, 0, 257)));
    }

    public void setRotationRight() {
        this.mUiAutomatorBridge.setRotation(3);
    }

    public void setRotationLeft() {
        this.mUiAutomatorBridge.setRotation(1);
    }

    public void setRotationNatural() {
        this.mUiAutomatorBridge.setRotation(0);
    }

    public void freezeRotation() {
        this.mUiAutomatorBridge.setRotation(-1);
    }

    public void unfreezeRotation() {
        this.mUiAutomatorBridge.setRotation(-2);
    }

    public boolean wakeDevice() throws RemoteException {
        if (!this.isScreenOn()) {
            this.sendKey(26, 0);
            return true;
        }
        return false;
    }

    public boolean sleepDevice() throws RemoteException {
        if (this.isScreenOn()) {
            this.sendKey(26, 0);
            return true;
        }
        return false;
    }

    public boolean isScreenOn() throws RemoteException {
        return this.mUiAutomatorBridge.isScreenOn();
    }

    private boolean injectEventSync(InputEvent event) {
        return this.mUiAutomatorBridge.injectInputEvent(event, true);
    }

    private int getPointerAction(int motionEnvent, int index) {
        return motionEnvent + (index << 8);
    }

    public boolean performMultiPointerGesture(MotionEvent.PointerCoords[] ... touches) {
        int x;
        boolean ret = true;
        if (touches.length < 2) {
            throw new IllegalArgumentException("Must provide coordinates for at least 2 pointers");
        }
        int maxSteps = 0;
        for (int x2 = 0; x2 < touches.length; ++x2) {
            maxSteps = maxSteps < touches[x2].length ? touches[x2].length : maxSteps;
        }
        MotionEvent.PointerProperties[] properties = new MotionEvent.PointerProperties[touches.length];
        MotionEvent.PointerCoords[] pointerCoords = new MotionEvent.PointerCoords[touches.length];
        for (int x3 = 0; x3 < touches.length; ++x3) {
            MotionEvent.PointerProperties prop = new MotionEvent.PointerProperties();
            prop.id = x3;
            prop.toolType = 1;
            properties[x3] = prop;
            pointerCoords[x3] = touches[x3][0];
        }
        long downTime = SystemClock.uptimeMillis();
        MotionEvent event = MotionEvent.obtain((long)downTime, (long)SystemClock.uptimeMillis(), (int)0, (int)1, (MotionEvent.PointerProperties[])properties, (MotionEvent.PointerCoords[])pointerCoords, (int)0, (int)0, (float)1.0f, (float)1.0f, (int)0, (int)0, (int)4098, (int)0);
        ret &= this.injectEventSync((InputEvent)event);
        for (x = 1; x < touches.length; ++x) {
            event = MotionEvent.obtain((long)downTime, (long)SystemClock.uptimeMillis(), (int)this.getPointerAction(5, x), (int)(x + 1), (MotionEvent.PointerProperties[])properties, (MotionEvent.PointerCoords[])pointerCoords, (int)0, (int)0, (float)1.0f, (float)1.0f, (int)0, (int)0, (int)4098, (int)0);
            ret &= this.injectEventSync((InputEvent)event);
        }
        for (int i = 1; i < maxSteps - 1; ++i) {
            for (int x4 = 0; x4 < touches.length; ++x4) {
                pointerCoords[x4] = touches[x4].length > i ? touches[x4][i] : touches[x4][touches[x4].length - 1];
            }
            event = MotionEvent.obtain((long)downTime, (long)SystemClock.uptimeMillis(), (int)2, (int)touches.length, (MotionEvent.PointerProperties[])properties, (MotionEvent.PointerCoords[])pointerCoords, (int)0, (int)0, (float)1.0f, (float)1.0f, (int)0, (int)0, (int)4098, (int)0);
            ret &= this.injectEventSync((InputEvent)event);
            SystemClock.sleep((long)5L);
        }
        for (x = 0; x < touches.length; ++x) {
            pointerCoords[x] = touches[x][touches[x].length - 1];
        }
        for (x = 1; x < touches.length; ++x) {
            event = MotionEvent.obtain((long)downTime, (long)SystemClock.uptimeMillis(), (int)this.getPointerAction(6, x), (int)(x + 1), (MotionEvent.PointerProperties[])properties, (MotionEvent.PointerCoords[])pointerCoords, (int)0, (int)0, (float)1.0f, (float)1.0f, (int)0, (int)0, (int)4098, (int)0);
            ret &= this.injectEventSync((InputEvent)event);
        }
        Log.i((String)LOG_TAG, (String)("x " + pointerCoords[0].x));
        event = MotionEvent.obtain((long)downTime, (long)SystemClock.uptimeMillis(), (int)1, (int)1, (MotionEvent.PointerProperties[])properties, (MotionEvent.PointerCoords[])pointerCoords, (int)0, (int)0, (float)1.0f, (float)1.0f, (int)0, (int)0, (int)4098, (int)0);
        return ret &= this.injectEventSync((InputEvent)event);
    }

    public boolean toggleRecentApps() {
        return this.mUiAutomatorBridge.performGlobalAction(3);
    }

    public boolean openNotification() {
        return this.mUiAutomatorBridge.performGlobalAction(4);
    }

    public boolean openQuickSettings() {
        return this.mUiAutomatorBridge.performGlobalAction(5);
    }

    class WaitForAllEventPredicate
    implements UiAutomation.AccessibilityEventFilter {
        int mMask;

        WaitForAllEventPredicate(int mask) {
            this.mMask = mask;
        }

        public boolean accept(AccessibilityEvent t) {
            if ((t.getEventType() & this.mMask) != 0) {
                this.mMask &= ~t.getEventType();
                return this.mMask == 0;
            }
            return false;
        }
    }

    class EventCollectingPredicate
    implements UiAutomation.AccessibilityEventFilter {
        int mMask;
        List<AccessibilityEvent> mEventsList;

        EventCollectingPredicate(int mask, List<AccessibilityEvent> events) {
            this.mMask = mask;
            this.mEventsList = events;
        }

        public boolean accept(AccessibilityEvent t) {
            if ((t.getEventType() & this.mMask) != 0) {
                this.mEventsList.add(AccessibilityEvent.obtain((AccessibilityEvent)t));
            }
            return false;
        }
    }

    class WaitForAnyEventPredicate
    implements UiAutomation.AccessibilityEventFilter {
        int mMask;

        WaitForAnyEventPredicate(int mask) {
            this.mMask = mask;
        }

        public boolean accept(AccessibilityEvent t) {
            return (t.getEventType() & this.mMask) != 0;
        }
    }
}

