/*
 * Decompiled with CFR 0.152.
 */
package android.support.test.uiautomator;

import android.accessibilityservice.AccessibilityServiceInfo;
import android.app.UiAutomation;
import android.graphics.Bitmap;
import android.support.test.uiautomator.InteractionController;
import android.support.test.uiautomator.QueryController;
import android.util.Log;
import android.view.Display;
import android.view.InputEvent;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.TimeoutException;

public abstract class UiAutomatorBridge {
    private static final String LOG_TAG = UiAutomatorBridge.class.getSimpleName();
    private static final long QUIET_TIME_TO_BE_CONSIDERD_IDLE_STATE = 500L;
    private static final long TOTAL_TIME_TO_WAIT_FOR_IDLE_STATE = 10000L;
    private final UiAutomation mUiAutomation;
    private final InteractionController mInteractionController;
    private final QueryController mQueryController;

    UiAutomatorBridge(UiAutomation uiAutomation) {
        this.mUiAutomation = uiAutomation;
        this.mInteractionController = new InteractionController(this);
        this.mQueryController = new QueryController(this);
    }

    InteractionController getInteractionController() {
        return this.mInteractionController;
    }

    QueryController getQueryController() {
        return this.mQueryController;
    }

    public void setOnAccessibilityEventListener(UiAutomation.OnAccessibilityEventListener listener) {
        this.mUiAutomation.setOnAccessibilityEventListener(listener);
    }

    public AccessibilityNodeInfo getRootInActiveWindow() {
        return this.mUiAutomation.getRootInActiveWindow();
    }

    public boolean injectInputEvent(InputEvent event, boolean sync) {
        return this.mUiAutomation.injectInputEvent(event, sync);
    }

    public boolean setRotation(int rotation) {
        return this.mUiAutomation.setRotation(rotation);
    }

    public void setCompressedLayoutHierarchy(boolean compressed) {
        AccessibilityServiceInfo info = this.mUiAutomation.getServiceInfo();
        info.flags = compressed ? (info.flags &= 0xFFFFFFFD) : (info.flags |= 2);
        this.mUiAutomation.setServiceInfo(info);
    }

    public abstract int getRotation();

    public abstract boolean isScreenOn();

    public void waitForIdle() {
        this.waitForIdle(10000L);
    }

    public void waitForIdle(long timeout) {
        try {
            this.mUiAutomation.waitForIdle(500L, timeout);
        }
        catch (TimeoutException te) {
            Log.w((String)LOG_TAG, (String)"Could not detect idle state.", (Throwable)te);
        }
    }

    public AccessibilityEvent executeCommandAndWaitForAccessibilityEvent(Runnable command, UiAutomation.AccessibilityEventFilter filter, long timeoutMillis) throws TimeoutException {
        return this.mUiAutomation.executeAndWaitForEvent(command, filter, timeoutMillis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean takeScreenshot(File storePath, int quality) {
        Bitmap screenshot = this.mUiAutomation.takeScreenshot();
        if (screenshot == null) {
            return false;
        }
        FilterOutputStream bos = null;
        try {
            bos = new BufferedOutputStream(new FileOutputStream(storePath));
            if (bos != null) {
                screenshot.compress(Bitmap.CompressFormat.PNG, quality, (OutputStream)bos);
                ((BufferedOutputStream)bos).flush();
            }
        }
        catch (IOException ioe) {
            Log.e((String)LOG_TAG, (String)"failed to save screen shot to file", (Throwable)ioe);
            boolean bl = false;
            return bl;
        }
        finally {
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException ioe) {}
            }
            screenshot.recycle();
        }
        return true;
    }

    public boolean performGlobalAction(int action) {
        return this.mUiAutomation.performGlobalAction(action);
    }

    public abstract Display getDefaultDisplay();

    public abstract long getSystemLongPressTime();
}

