/*
 * Decompiled with CFR 0.152.
 */
package android.support.test.uiautomator;

import android.support.test.uiautomator.Tracer;
import android.support.test.uiautomator.UiAutomatorTestCase;
import android.test.AndroidTestRunner;
import android.test.InstrumentationTestRunner;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestListener;

public class UiAutomatorInstrumentationTestRunner
extends InstrumentationTestRunner {
    public void onStart() {
        String traceType = this.getArguments().getString("traceOutputMode");
        if (traceType != null) {
            Tracer.Mode mode = Tracer.Mode.valueOf(Tracer.Mode.class, traceType);
            if (mode == Tracer.Mode.FILE || mode == Tracer.Mode.ALL) {
                String filename = this.getArguments().getString("traceLogFilename");
                if (filename == null) {
                    throw new RuntimeException("Name of log file not specified. Please specify it using traceLogFilename parameter");
                }
                Tracer.getInstance().setOutputFilename(filename);
            }
            Tracer.getInstance().setOutputMode(mode);
        }
        super.onStart();
    }

    protected void initializeUiAutomatorTest(UiAutomatorTestCase test) {
        test.initialize(this.getArguments());
    }

    protected AndroidTestRunner getAndroidTestRunner() {
        AndroidTestRunner testRunner = super.getAndroidTestRunner();
        testRunner.addTestListener(new TestListener(){

            public void startTest(Test test) {
                if (test instanceof UiAutomatorTestCase) {
                    UiAutomatorInstrumentationTestRunner.this.initializeUiAutomatorTest((UiAutomatorTestCase)test);
                }
            }

            public void endTest(Test test) {
            }

            public void addFailure(Test test, AssertionFailedError e) {
            }

            public void addError(Test test, Throwable t) {
            }
        });
        return testRunner;
    }
}

