/*
 * Decompiled with CFR 0.152.
 */
package android.support.test.uiautomator;

import android.app.Instrumentation;
import android.app.UiAutomation;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.graphics.Point;
import android.os.Build;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.os.SystemClock;
import android.support.test.uiautomator.AccessibilityNodeInfoDumper;
import android.support.test.uiautomator.ByMatcher;
import android.support.test.uiautomator.BySelector;
import android.support.test.uiautomator.Configurator;
import android.support.test.uiautomator.EventCondition;
import android.support.test.uiautomator.InstrumentationUiAutomatorBridge;
import android.support.test.uiautomator.QueryController;
import android.support.test.uiautomator.SearchCondition;
import android.support.test.uiautomator.Searchable;
import android.support.test.uiautomator.Tracer;
import android.support.test.uiautomator.UiObject;
import android.support.test.uiautomator.UiObject2;
import android.support.test.uiautomator.UiSelector;
import android.support.test.uiautomator.UiWatcher;
import android.support.test.uiautomator.WaitMixin;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.Display;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeoutException;

public class UiDevice
implements Searchable {
    private static final String LOG_TAG = UiDevice.class.getSimpleName();
    private static final long KEY_PRESS_EVENT_TIMEOUT = 1000L;
    private final HashMap<String, UiWatcher> mWatchers = new HashMap();
    private final List<String> mWatchersTriggers = new ArrayList<String>();
    private boolean mInWatcherContext = false;
    private InstrumentationUiAutomatorBridge mUiAutomationBridge;
    private Instrumentation mInstrumentation;
    private static UiDevice sInstance;
    private WaitMixin<UiDevice> mWaitMixin = new WaitMixin<UiDevice>(this);
    static final int API_LEVEL_ACTUAL;

    @Deprecated
    private UiDevice() {
    }

    private UiDevice(Instrumentation instrumentation) {
        this.mInstrumentation = instrumentation;
        this.mUiAutomationBridge = new InstrumentationUiAutomatorBridge(instrumentation.getContext(), instrumentation.getUiAutomation());
    }

    @Deprecated
    public void initialize(InstrumentationUiAutomatorBridge uiAutomatorBridge) {
        this.mUiAutomationBridge = uiAutomatorBridge;
    }

    boolean isInWatcherContext() {
        return this.mInWatcherContext;
    }

    InstrumentationUiAutomatorBridge getAutomatorBridge() {
        if (this.mUiAutomationBridge == null) {
            throw new RuntimeException("UiDevice not initialized");
        }
        return this.mUiAutomationBridge;
    }

    public UiObject findObject(UiSelector selector) {
        return new UiObject(this, selector);
    }

    @Override
    public boolean hasObject(BySelector selector) {
        QueryController qc = this.getAutomatorBridge().getQueryController();
        AccessibilityNodeInfo node = ByMatcher.findMatch(this, qc.getRootNode(), selector);
        if (node != null) {
            node.recycle();
            return true;
        }
        return false;
    }

    @Override
    public UiObject2 findObject(BySelector selector) {
        QueryController qc = this.getAutomatorBridge().getQueryController();
        AccessibilityNodeInfo node = ByMatcher.findMatch(this, qc.getRootNode(), selector);
        return node != null ? new UiObject2(this, selector, node) : null;
    }

    @Override
    public List<UiObject2> findObjects(BySelector selector) {
        ArrayList<UiObject2> ret = new ArrayList<UiObject2>();
        QueryController qc = this.getAutomatorBridge().getQueryController();
        for (AccessibilityNodeInfo node : ByMatcher.findMatches(this, qc.getRootNode(), selector)) {
            ret.add(new UiObject2(this, selector, node));
        }
        return ret;
    }

    public <R> R wait(SearchCondition<R> condition, long timeout) {
        return this.mWaitMixin.wait(condition, timeout);
    }

    public <R> R performActionAndWait(Runnable action, EventCondition<R> condition, long timeout) {
        AccessibilityEvent event = null;
        try {
            event = this.getAutomatorBridge().executeCommandAndWaitForAccessibilityEvent(action, new EventForwardingFilter(condition), timeout);
        }
        catch (TimeoutException e) {
            // empty catch block
        }
        if (event != null) {
            event.recycle();
        }
        return condition.getResult();
    }

    public void setCompressedLayoutHeirarchy(boolean compressed) {
        this.getAutomatorBridge().setCompressedLayoutHierarchy(compressed);
    }

    @Deprecated
    public static UiDevice getInstance() {
        if (sInstance == null) {
            throw new IllegalStateException("UiDevice singleton not initialized");
        }
        return sInstance;
    }

    public static UiDevice getInstance(Instrumentation instrumentation) {
        if (sInstance == null) {
            sInstance = new UiDevice(instrumentation);
        }
        return sInstance;
    }

    public Point getDisplaySizeDp() {
        Tracer.trace(new Object[0]);
        Display display = this.getAutomatorBridge().getDefaultDisplay();
        Point p = new Point();
        display.getRealSize(p);
        DisplayMetrics metrics = new DisplayMetrics();
        display.getRealMetrics(metrics);
        float dpx = (float)p.x / metrics.density;
        float dpy = (float)p.y / metrics.density;
        p.x = Math.round(dpx);
        p.y = Math.round(dpy);
        return p;
    }

    public String getProductName() {
        Tracer.trace(new Object[0]);
        return Build.PRODUCT;
    }

    public String getLastTraversedText() {
        Tracer.trace(new Object[0]);
        return this.getAutomatorBridge().getQueryController().getLastTraversedText();
    }

    public void clearLastTraversedText() {
        Tracer.trace(new Object[0]);
        this.getAutomatorBridge().getQueryController().clearLastTraversedText();
    }

    public boolean pressMenu() {
        Tracer.trace(new Object[0]);
        this.waitForIdle();
        return this.getAutomatorBridge().getInteractionController().sendKeyAndWaitForEvent(82, 0, 2048, 1000L);
    }

    public boolean pressBack() {
        Tracer.trace(new Object[0]);
        this.waitForIdle();
        return this.getAutomatorBridge().getInteractionController().sendKeyAndWaitForEvent(4, 0, 2048, 1000L);
    }

    public boolean pressHome() {
        Tracer.trace(new Object[0]);
        this.waitForIdle();
        return this.getAutomatorBridge().getInteractionController().sendKeyAndWaitForEvent(3, 0, 2048, 1000L);
    }

    public boolean pressSearch() {
        Tracer.trace(new Object[0]);
        return this.pressKeyCode(84);
    }

    public boolean pressDPadCenter() {
        Tracer.trace(new Object[0]);
        return this.pressKeyCode(23);
    }

    public boolean pressDPadDown() {
        Tracer.trace(new Object[0]);
        return this.pressKeyCode(20);
    }

    public boolean pressDPadUp() {
        Tracer.trace(new Object[0]);
        return this.pressKeyCode(19);
    }

    public boolean pressDPadLeft() {
        Tracer.trace(new Object[0]);
        return this.pressKeyCode(21);
    }

    public boolean pressDPadRight() {
        Tracer.trace(new Object[0]);
        return this.pressKeyCode(22);
    }

    public boolean pressDelete() {
        Tracer.trace(new Object[0]);
        return this.pressKeyCode(67);
    }

    public boolean pressEnter() {
        Tracer.trace(new Object[0]);
        return this.pressKeyCode(66);
    }

    public boolean pressKeyCode(int keyCode) {
        Tracer.trace(keyCode);
        this.waitForIdle();
        return this.getAutomatorBridge().getInteractionController().sendKey(keyCode, 0);
    }

    public boolean pressKeyCode(int keyCode, int metaState) {
        Tracer.trace(keyCode, metaState);
        this.waitForIdle();
        return this.getAutomatorBridge().getInteractionController().sendKey(keyCode, metaState);
    }

    public boolean pressRecentApps() throws RemoteException {
        Tracer.trace(new Object[0]);
        this.waitForIdle();
        return this.getAutomatorBridge().getInteractionController().toggleRecentApps();
    }

    public boolean openNotification() {
        Tracer.trace(new Object[0]);
        this.waitForIdle();
        return this.getAutomatorBridge().getInteractionController().openNotification();
    }

    public boolean openQuickSettings() {
        Tracer.trace(new Object[0]);
        this.waitForIdle();
        return this.getAutomatorBridge().getInteractionController().openQuickSettings();
    }

    public int getDisplayWidth() {
        Tracer.trace(new Object[0]);
        Display display = this.getAutomatorBridge().getDefaultDisplay();
        Point p = new Point();
        display.getSize(p);
        return p.x;
    }

    public int getDisplayHeight() {
        Tracer.trace(new Object[0]);
        Display display = this.getAutomatorBridge().getDefaultDisplay();
        Point p = new Point();
        display.getSize(p);
        return p.y;
    }

    public boolean click(int x, int y) {
        Tracer.trace(x, y);
        if (x >= this.getDisplayWidth() || y >= this.getDisplayHeight()) {
            return false;
        }
        return this.getAutomatorBridge().getInteractionController().clickNoSync(x, y);
    }

    public boolean swipe(int startX, int startY, int endX, int endY, int steps) {
        Tracer.trace(startX, startY, endX, endY, steps);
        return this.getAutomatorBridge().getInteractionController().swipe(startX, startY, endX, endY, steps);
    }

    public boolean drag(int startX, int startY, int endX, int endY, int steps) {
        Tracer.trace(startX, startY, endX, endY, steps);
        return this.getAutomatorBridge().getInteractionController().swipe(startX, startY, endX, endY, steps, true);
    }

    public boolean swipe(Point[] segments, int segmentSteps) {
        Tracer.trace(segments, segmentSteps);
        return this.getAutomatorBridge().getInteractionController().swipe(segments, segmentSteps);
    }

    public void waitForIdle() {
        Tracer.trace(new Object[0]);
        this.waitForIdle(Configurator.getInstance().getWaitForIdleTimeout());
    }

    public void waitForIdle(long timeout) {
        Tracer.trace(timeout);
        this.getAutomatorBridge().waitForIdle(timeout);
    }

    @Deprecated
    public String getCurrentActivityName() {
        Tracer.trace(new Object[0]);
        return this.getAutomatorBridge().getQueryController().getCurrentActivityName();
    }

    public String getCurrentPackageName() {
        Tracer.trace(new Object[0]);
        return this.getAutomatorBridge().getQueryController().getCurrentPackageName();
    }

    public void registerWatcher(String name, UiWatcher watcher) {
        Tracer.trace(name, watcher);
        if (this.mInWatcherContext) {
            throw new IllegalStateException("Cannot register new watcher from within another");
        }
        this.mWatchers.put(name, watcher);
    }

    public void removeWatcher(String name) {
        Tracer.trace(name);
        if (this.mInWatcherContext) {
            throw new IllegalStateException("Cannot remove a watcher from within another");
        }
        this.mWatchers.remove(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runWatchers() {
        Tracer.trace(new Object[0]);
        if (this.mInWatcherContext) {
            return;
        }
        for (String watcherName : this.mWatchers.keySet()) {
            UiWatcher watcher = this.mWatchers.get(watcherName);
            if (watcher == null) continue;
            try {
                this.mInWatcherContext = true;
                if (!watcher.checkForCondition()) continue;
                this.setWatcherTriggered(watcherName);
            }
            catch (Exception e) {
                Log.e((String)LOG_TAG, (String)("Exceuting watcher: " + watcherName), (Throwable)e);
            }
            finally {
                this.mInWatcherContext = false;
            }
        }
    }

    public void resetWatcherTriggers() {
        Tracer.trace(new Object[0]);
        this.mWatchersTriggers.clear();
    }

    public boolean hasWatcherTriggered(String watcherName) {
        Tracer.trace(watcherName);
        return this.mWatchersTriggers.contains(watcherName);
    }

    public boolean hasAnyWatcherTriggered() {
        Tracer.trace(new Object[0]);
        return this.mWatchersTriggers.size() > 0;
    }

    private void setWatcherTriggered(String watcherName) {
        Tracer.trace(watcherName);
        if (!this.hasWatcherTriggered(watcherName)) {
            this.mWatchersTriggers.add(watcherName);
        }
    }

    public boolean isNaturalOrientation() {
        Tracer.trace(new Object[0]);
        this.waitForIdle();
        int ret = this.getAutomatorBridge().getRotation();
        return ret == 0 || ret == 2;
    }

    public int getDisplayRotation() {
        Tracer.trace(new Object[0]);
        this.waitForIdle();
        return this.getAutomatorBridge().getRotation();
    }

    public void freezeRotation() throws RemoteException {
        Tracer.trace(new Object[0]);
        this.getAutomatorBridge().getInteractionController().freezeRotation();
    }

    public void unfreezeRotation() throws RemoteException {
        Tracer.trace(new Object[0]);
        this.getAutomatorBridge().getInteractionController().unfreezeRotation();
    }

    public void setOrientationLeft() throws RemoteException {
        Tracer.trace(new Object[0]);
        this.getAutomatorBridge().getInteractionController().setRotationLeft();
        this.waitForIdle();
    }

    public void setOrientationRight() throws RemoteException {
        Tracer.trace(new Object[0]);
        this.getAutomatorBridge().getInteractionController().setRotationRight();
        this.waitForIdle();
    }

    public void setOrientationNatural() throws RemoteException {
        Tracer.trace(new Object[0]);
        this.getAutomatorBridge().getInteractionController().setRotationNatural();
        this.waitForIdle();
    }

    public void wakeUp() throws RemoteException {
        Tracer.trace(new Object[0]);
        if (this.getAutomatorBridge().getInteractionController().wakeDevice()) {
            SystemClock.sleep((long)500L);
        }
    }

    public boolean isScreenOn() throws RemoteException {
        Tracer.trace(new Object[0]);
        return this.getAutomatorBridge().getInteractionController().isScreenOn();
    }

    public void sleep() throws RemoteException {
        Tracer.trace(new Object[0]);
        this.getAutomatorBridge().getInteractionController().sleepDevice();
    }

    @Deprecated
    public void dumpWindowHierarchy(String fileName) {
        Tracer.trace(fileName);
        File dumpFile = new File(fileName);
        if (!dumpFile.isAbsolute()) {
            dumpFile = this.getAutomatorBridge().getContext().getFileStreamPath(fileName);
        }
        try {
            this.dumpWindowHierarchy(dumpFile);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpWindowHierarchy(File dest) throws IOException {
        try (BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(dest));){
            this.dumpWindowHierarchy(new BufferedOutputStream(new FileOutputStream(dest)));
        }
    }

    public void dumpWindowHierarchy(OutputStream out) throws IOException {
        AccessibilityNodeInfoDumper.dumpWindowHierarchy(this, out);
    }

    public boolean waitForWindowUpdate(final String packageName, long timeout) {
        Tracer.trace(packageName, timeout);
        if (packageName != null && !packageName.equals(this.getCurrentPackageName())) {
            return false;
        }
        Runnable emptyRunnable = new Runnable(){

            @Override
            public void run() {
            }
        };
        UiAutomation.AccessibilityEventFilter checkWindowUpdate = new UiAutomation.AccessibilityEventFilter(){

            public boolean accept(AccessibilityEvent t) {
                if (t.getEventType() == 2048) {
                    return packageName == null || packageName.equals(t.getPackageName());
                }
                return false;
            }
        };
        try {
            this.getAutomatorBridge().executeCommandAndWaitForAccessibilityEvent(emptyRunnable, checkWindowUpdate, timeout);
        }
        catch (TimeoutException e) {
            return false;
        }
        catch (Exception e) {
            Log.e((String)LOG_TAG, (String)"waitForWindowUpdate: general exception from bridge", (Throwable)e);
            return false;
        }
        return true;
    }

    public boolean takeScreenshot(File storePath) {
        Tracer.trace(storePath);
        return this.takeScreenshot(storePath, 1.0f, 90);
    }

    public boolean takeScreenshot(File storePath, float scale, int quality) {
        Tracer.trace(storePath, Float.valueOf(scale), quality);
        return this.getAutomatorBridge().takeScreenshot(storePath, quality);
    }

    public String getLauncherPackageName() {
        Intent intent = new Intent("android.intent.action.MAIN");
        intent.addCategory("android.intent.category.HOME");
        PackageManager pm = this.mInstrumentation.getContext().getPackageManager();
        ResolveInfo resolveInfo = pm.resolveActivity(intent, 65536);
        return resolveInfo.activityInfo.packageName;
    }

    public String executeShellCommand(String cmd) throws IOException {
        int bytesRead;
        ParcelFileDescriptor pfd = this.mInstrumentation.getUiAutomation().executeShellCommand(cmd);
        byte[] buf = new byte[512];
        ParcelFileDescriptor.AutoCloseInputStream fis = new ParcelFileDescriptor.AutoCloseInputStream(pfd);
        StringBuffer stdout = new StringBuffer();
        while ((bytesRead = fis.read(buf)) != -1) {
            stdout.append(new String(buf, 0, bytesRead));
        }
        fis.close();
        return stdout.toString();
    }

    AccessibilityNodeInfo getActiveWindowRoot() {
        QueryController qc = this.getAutomatorBridge().getQueryController();
        return qc.getRootNode();
    }

    static {
        API_LEVEL_ACTUAL = Build.VERSION.SDK_INT + ("REL".equals(Build.VERSION.CODENAME) ? 0 : 1);
    }

    private static class EventForwardingFilter
    implements UiAutomation.AccessibilityEventFilter {
        private EventCondition<?> mCondition;

        public EventForwardingFilter(EventCondition<?> condition) {
            this.mCondition = condition;
        }

        public boolean accept(AccessibilityEvent event) {
            return Boolean.TRUE.equals(this.mCondition.apply(event));
        }
    }
}

