/*
 * Decompiled with CFR 0.152.
 */
package android.support.test.uiautomator;

import android.graphics.Point;
import android.graphics.Rect;
import android.os.Bundle;
import android.os.SystemClock;
import android.support.test.uiautomator.AccessibilityNodeInfoHelper;
import android.support.test.uiautomator.Configurator;
import android.support.test.uiautomator.InteractionController;
import android.support.test.uiautomator.QueryController;
import android.support.test.uiautomator.Tracer;
import android.support.test.uiautomator.UiDevice;
import android.support.test.uiautomator.UiObjectNotFoundException;
import android.support.test.uiautomator.UiSelector;
import android.util.Log;
import android.view.MotionEvent;
import android.view.accessibility.AccessibilityNodeInfo;

public class UiObject {
    private static final String LOG_TAG = UiObject.class.getSimpleName();
    @Deprecated
    protected static final long WAIT_FOR_SELECTOR_TIMEOUT = 10000L;
    protected static final long WAIT_FOR_SELECTOR_POLL = 1000L;
    protected static final long WAIT_FOR_WINDOW_TMEOUT = 5500L;
    protected static final int SWIPE_MARGIN_LIMIT = 5;
    @Deprecated
    protected static final long WAIT_FOR_EVENT_TMEOUT = 3000L;
    protected static final int FINGER_TOUCH_HALF_WIDTH = 20;
    private final UiSelector mUiSelector;
    private final UiDevice mDevice;
    private final Configurator mConfig = Configurator.getInstance();

    @Deprecated
    public UiObject(UiSelector selector) {
        this.mUiSelector = selector;
        this.mDevice = UiDevice.getInstance();
    }

    UiObject(UiDevice device, UiSelector selector) {
        this.mDevice = device;
        this.mUiSelector = selector;
    }

    public final UiSelector getSelector() {
        Tracer.trace(new Object[0]);
        if (this.mUiSelector == null) {
            throw new IllegalStateException("UiSelector not set");
        }
        return this.mUiSelector;
    }

    QueryController getQueryController() {
        return this.mDevice.getAutomatorBridge().getQueryController();
    }

    InteractionController getInteractionController() {
        return this.mDevice.getAutomatorBridge().getInteractionController();
    }

    public UiObject getChild(UiSelector selector) throws UiObjectNotFoundException {
        Tracer.trace(selector);
        return new UiObject(this.getSelector().childSelector(selector));
    }

    public UiObject getFromParent(UiSelector selector) throws UiObjectNotFoundException {
        Tracer.trace(selector);
        return new UiObject(this.getSelector().fromParent(selector));
    }

    public int getChildCount() throws UiObjectNotFoundException {
        Tracer.trace(new Object[0]);
        AccessibilityNodeInfo node = this.findAccessibilityNodeInfo(this.mConfig.getWaitForSelectorTimeout());
        if (node == null) {
            throw new UiObjectNotFoundException(this.mUiSelector.toString());
        }
        return node.getChildCount();
    }

    protected AccessibilityNodeInfo findAccessibilityNodeInfo(long timeout) {
        AccessibilityNodeInfo node = null;
        long startMills = SystemClock.uptimeMillis();
        long currentMills = 0L;
        while (currentMills <= timeout && (node = this.getQueryController().findAccessibilityNodeInfo(this.mUiSelector)) == null) {
            this.mDevice.runWatchers();
            currentMills = SystemClock.uptimeMillis() - startMills;
            if (timeout <= 0L) continue;
            SystemClock.sleep((long)1000L);
        }
        return node;
    }

    public boolean dragTo(UiObject destObj, int steps) throws UiObjectNotFoundException {
        Rect srcRect = this.getVisibleBounds();
        Rect dstRect = destObj.getVisibleBounds();
        return this.getInteractionController().swipe(srcRect.centerX(), srcRect.centerY(), dstRect.centerX(), dstRect.centerY(), steps, true);
    }

    public boolean dragTo(int destX, int destY, int steps) throws UiObjectNotFoundException {
        Rect srcRect = this.getVisibleBounds();
        return this.getInteractionController().swipe(srcRect.centerX(), srcRect.centerY(), destX, destY, steps, true);
    }

    public boolean swipeUp(int steps) throws UiObjectNotFoundException {
        Tracer.trace(steps);
        Rect rect = this.getVisibleBounds();
        if (rect.height() <= 10) {
            return false;
        }
        return this.getInteractionController().swipe(rect.centerX(), rect.bottom - 5, rect.centerX(), rect.top + 5, steps);
    }

    public boolean swipeDown(int steps) throws UiObjectNotFoundException {
        Tracer.trace(steps);
        Rect rect = this.getVisibleBounds();
        if (rect.height() <= 10) {
            return false;
        }
        return this.getInteractionController().swipe(rect.centerX(), rect.top + 5, rect.centerX(), rect.bottom - 5, steps);
    }

    public boolean swipeLeft(int steps) throws UiObjectNotFoundException {
        Tracer.trace(steps);
        Rect rect = this.getVisibleBounds();
        if (rect.width() <= 10) {
            return false;
        }
        return this.getInteractionController().swipe(rect.right - 5, rect.centerY(), rect.left + 5, rect.centerY(), steps);
    }

    public boolean swipeRight(int steps) throws UiObjectNotFoundException {
        Tracer.trace(steps);
        Rect rect = this.getVisibleBounds();
        if (rect.width() <= 10) {
            return false;
        }
        return this.getInteractionController().swipe(rect.left + 5, rect.centerY(), rect.right - 5, rect.centerY(), steps);
    }

    private Rect getVisibleBounds(AccessibilityNodeInfo node) {
        if (node == null) {
            return null;
        }
        int w = this.mDevice.getDisplayWidth();
        int h = this.mDevice.getDisplayHeight();
        Rect nodeRect = AccessibilityNodeInfoHelper.getVisibleBoundsInScreen(node, w, h);
        AccessibilityNodeInfo scrollableParentNode = this.getScrollableParent(node);
        if (scrollableParentNode == null) {
            return nodeRect;
        }
        Rect parentRect = AccessibilityNodeInfoHelper.getVisibleBoundsInScreen(scrollableParentNode, w, h);
        nodeRect.intersect(parentRect);
        return nodeRect;
    }

    private AccessibilityNodeInfo getScrollableParent(AccessibilityNodeInfo node) {
        AccessibilityNodeInfo parent = node;
        while (parent != null) {
            if ((parent = parent.getParent()) == null || !parent.isScrollable()) continue;
            return parent;
        }
        return null;
    }

    public boolean click() throws UiObjectNotFoundException {
        Tracer.trace(new Object[0]);
        AccessibilityNodeInfo node = this.findAccessibilityNodeInfo(this.mConfig.getWaitForSelectorTimeout());
        if (node == null) {
            throw new UiObjectNotFoundException(this.mUiSelector.toString());
        }
        Rect rect = this.getVisibleBounds(node);
        return this.getInteractionController().clickAndSync(rect.centerX(), rect.centerY(), this.mConfig.getActionAcknowledgmentTimeout());
    }

    public boolean clickAndWaitForNewWindow() throws UiObjectNotFoundException {
        Tracer.trace(new Object[0]);
        return this.clickAndWaitForNewWindow(5500L);
    }

    public boolean clickAndWaitForNewWindow(long timeout) throws UiObjectNotFoundException {
        Tracer.trace(timeout);
        AccessibilityNodeInfo node = this.findAccessibilityNodeInfo(this.mConfig.getWaitForSelectorTimeout());
        if (node == null) {
            throw new UiObjectNotFoundException(this.mUiSelector.toString());
        }
        Rect rect = this.getVisibleBounds(node);
        return this.getInteractionController().clickAndWaitForNewWindow(rect.centerX(), rect.centerY(), timeout);
    }

    public boolean clickTopLeft() throws UiObjectNotFoundException {
        Tracer.trace(new Object[0]);
        AccessibilityNodeInfo node = this.findAccessibilityNodeInfo(this.mConfig.getWaitForSelectorTimeout());
        if (node == null) {
            throw new UiObjectNotFoundException(this.mUiSelector.toString());
        }
        Rect rect = this.getVisibleBounds(node);
        return this.getInteractionController().clickAndSync(rect.left + 5, rect.top + 5, this.mConfig.getActionAcknowledgmentTimeout());
    }

    public boolean longClickBottomRight() throws UiObjectNotFoundException {
        Tracer.trace(new Object[0]);
        AccessibilityNodeInfo node = this.findAccessibilityNodeInfo(this.mConfig.getWaitForSelectorTimeout());
        if (node == null) {
            throw new UiObjectNotFoundException(this.mUiSelector.toString());
        }
        Rect rect = this.getVisibleBounds(node);
        return this.getInteractionController().longTapAndSync(rect.right - 5, rect.bottom - 5, this.mConfig.getActionAcknowledgmentTimeout());
    }

    public boolean clickBottomRight() throws UiObjectNotFoundException {
        Tracer.trace(new Object[0]);
        AccessibilityNodeInfo node = this.findAccessibilityNodeInfo(this.mConfig.getWaitForSelectorTimeout());
        if (node == null) {
            throw new UiObjectNotFoundException(this.mUiSelector.toString());
        }
        Rect rect = this.getVisibleBounds(node);
        return this.getInteractionController().clickAndSync(rect.right - 5, rect.bottom - 5, this.mConfig.getActionAcknowledgmentTimeout());
    }

    public boolean longClick() throws UiObjectNotFoundException {
        Tracer.trace(new Object[0]);
        AccessibilityNodeInfo node = this.findAccessibilityNodeInfo(this.mConfig.getWaitForSelectorTimeout());
        if (node == null) {
            throw new UiObjectNotFoundException(this.mUiSelector.toString());
        }
        Rect rect = this.getVisibleBounds(node);
        return this.getInteractionController().longTapAndSync(rect.centerX(), rect.centerY(), this.mConfig.getActionAcknowledgmentTimeout());
    }

    public boolean longClickTopLeft() throws UiObjectNotFoundException {
        Tracer.trace(new Object[0]);
        AccessibilityNodeInfo node = this.findAccessibilityNodeInfo(this.mConfig.getWaitForSelectorTimeout());
        if (node == null) {
            throw new UiObjectNotFoundException(this.mUiSelector.toString());
        }
        Rect rect = this.getVisibleBounds(node);
        return this.getInteractionController().longTapAndSync(rect.left + 5, rect.top + 5, this.mConfig.getActionAcknowledgmentTimeout());
    }

    public String getText() throws UiObjectNotFoundException {
        Tracer.trace(new Object[0]);
        AccessibilityNodeInfo node = this.findAccessibilityNodeInfo(this.mConfig.getWaitForSelectorTimeout());
        if (node == null) {
            throw new UiObjectNotFoundException(this.mUiSelector.toString());
        }
        String retVal = this.safeStringReturn(node.getText());
        Log.d((String)LOG_TAG, (String)String.format("getText() = %s", retVal));
        return retVal;
    }

    public String getClassName() throws UiObjectNotFoundException {
        Tracer.trace(new Object[0]);
        AccessibilityNodeInfo node = this.findAccessibilityNodeInfo(this.mConfig.getWaitForSelectorTimeout());
        if (node == null) {
            throw new UiObjectNotFoundException(this.mUiSelector.toString());
        }
        String retVal = this.safeStringReturn(node.getClassName());
        Log.d((String)LOG_TAG, (String)String.format("getClassName() = %s", retVal));
        return retVal;
    }

    public String getContentDescription() throws UiObjectNotFoundException {
        Tracer.trace(new Object[0]);
        AccessibilityNodeInfo node = this.findAccessibilityNodeInfo(this.mConfig.getWaitForSelectorTimeout());
        if (node == null) {
            throw new UiObjectNotFoundException(this.mUiSelector.toString());
        }
        return this.safeStringReturn(node.getContentDescription());
    }

    public void legacySetText(String text) throws UiObjectNotFoundException {
        Tracer.trace(new Object[0]);
        AccessibilityNodeInfo node = this.findAccessibilityNodeInfo(this.mConfig.getWaitForSelectorTimeout());
        if (node == null) {
            throw new UiObjectNotFoundException(this.getSelector().toString());
        }
        Rect rect = this.getVisibleBounds(node);
        this.getInteractionController().longTapNoSync(rect.left + 20, rect.centerY());
        UiObject selectAll = new UiObject(new UiSelector().descriptionContains("Select all"));
        if (selectAll.waitForExists(50L)) {
            selectAll.click();
        }
        SystemClock.sleep((long)250L);
        this.getInteractionController().sendKey(67, 0);
        this.getInteractionController().sendText(text);
    }

    public boolean setText(String text) throws UiObjectNotFoundException {
        if (text == null) {
            text = "";
        }
        Tracer.trace(text);
        if (UiDevice.API_LEVEL_ACTUAL > 19) {
            AccessibilityNodeInfo node = this.findAccessibilityNodeInfo(this.mConfig.getWaitForSelectorTimeout());
            if (node == null) {
                throw new UiObjectNotFoundException(this.getSelector().toString());
            }
            Bundle args = new Bundle();
            args.putCharSequence("ACTION_ARGUMENT_SET_TEXT_CHARSEQUENCE", (CharSequence)text);
            return node.performAction(0x200000, args);
        }
        this.clearTextField();
        return this.getInteractionController().sendText(text);
    }

    public void clearTextField() throws UiObjectNotFoundException {
        Tracer.trace(new Object[0]);
        AccessibilityNodeInfo node = this.findAccessibilityNodeInfo(this.mConfig.getWaitForSelectorTimeout());
        if (node == null) {
            throw new UiObjectNotFoundException(this.mUiSelector.toString());
        }
        CharSequence text = node.getText();
        if (text != null && text.length() > 0) {
            if (UiDevice.API_LEVEL_ACTUAL > 19) {
                this.setText("");
            } else {
                Bundle selectionArgs = new Bundle();
                selectionArgs.putInt("ACTION_ARGUMENT_SELECTION_START_INT", 0);
                selectionArgs.putInt("ACTION_ARGUMENT_SELECTION_END_INT", text.length());
                boolean ret = node.performAction(1);
                if (!ret) {
                    Log.w((String)LOG_TAG, (String)"ACTION_FOCUS on text field failed.");
                }
                if (!(ret = node.performAction(131072, selectionArgs))) {
                    Log.w((String)LOG_TAG, (String)"ACTION_SET_SELECTION on text field failed.");
                }
                this.getInteractionController().sendKey(67, 0);
            }
        }
    }

    public boolean isChecked() throws UiObjectNotFoundException {
        Tracer.trace(new Object[0]);
        AccessibilityNodeInfo node = this.findAccessibilityNodeInfo(this.mConfig.getWaitForSelectorTimeout());
        if (node == null) {
            throw new UiObjectNotFoundException(this.mUiSelector.toString());
        }
        return node.isChecked();
    }

    public boolean isSelected() throws UiObjectNotFoundException {
        Tracer.trace(new Object[0]);
        AccessibilityNodeInfo node = this.findAccessibilityNodeInfo(this.mConfig.getWaitForSelectorTimeout());
        if (node == null) {
            throw new UiObjectNotFoundException(this.mUiSelector.toString());
        }
        return node.isSelected();
    }

    public boolean isCheckable() throws UiObjectNotFoundException {
        Tracer.trace(new Object[0]);
        AccessibilityNodeInfo node = this.findAccessibilityNodeInfo(this.mConfig.getWaitForSelectorTimeout());
        if (node == null) {
            throw new UiObjectNotFoundException(this.mUiSelector.toString());
        }
        return node.isCheckable();
    }

    public boolean isEnabled() throws UiObjectNotFoundException {
        Tracer.trace(new Object[0]);
        AccessibilityNodeInfo node = this.findAccessibilityNodeInfo(this.mConfig.getWaitForSelectorTimeout());
        if (node == null) {
            throw new UiObjectNotFoundException(this.mUiSelector.toString());
        }
        return node.isEnabled();
    }

    public boolean isClickable() throws UiObjectNotFoundException {
        Tracer.trace(new Object[0]);
        AccessibilityNodeInfo node = this.findAccessibilityNodeInfo(this.mConfig.getWaitForSelectorTimeout());
        if (node == null) {
            throw new UiObjectNotFoundException(this.mUiSelector.toString());
        }
        return node.isClickable();
    }

    public boolean isFocused() throws UiObjectNotFoundException {
        Tracer.trace(new Object[0]);
        AccessibilityNodeInfo node = this.findAccessibilityNodeInfo(this.mConfig.getWaitForSelectorTimeout());
        if (node == null) {
            throw new UiObjectNotFoundException(this.mUiSelector.toString());
        }
        return node.isFocused();
    }

    public boolean isFocusable() throws UiObjectNotFoundException {
        Tracer.trace(new Object[0]);
        AccessibilityNodeInfo node = this.findAccessibilityNodeInfo(this.mConfig.getWaitForSelectorTimeout());
        if (node == null) {
            throw new UiObjectNotFoundException(this.mUiSelector.toString());
        }
        return node.isFocusable();
    }

    public boolean isScrollable() throws UiObjectNotFoundException {
        Tracer.trace(new Object[0]);
        AccessibilityNodeInfo node = this.findAccessibilityNodeInfo(this.mConfig.getWaitForSelectorTimeout());
        if (node == null) {
            throw new UiObjectNotFoundException(this.mUiSelector.toString());
        }
        return node.isScrollable();
    }

    public boolean isLongClickable() throws UiObjectNotFoundException {
        Tracer.trace(new Object[0]);
        AccessibilityNodeInfo node = this.findAccessibilityNodeInfo(this.mConfig.getWaitForSelectorTimeout());
        if (node == null) {
            throw new UiObjectNotFoundException(this.mUiSelector.toString());
        }
        return node.isLongClickable();
    }

    public String getPackageName() throws UiObjectNotFoundException {
        Tracer.trace(new Object[0]);
        AccessibilityNodeInfo node = this.findAccessibilityNodeInfo(this.mConfig.getWaitForSelectorTimeout());
        if (node == null) {
            throw new UiObjectNotFoundException(this.mUiSelector.toString());
        }
        return this.safeStringReturn(node.getPackageName());
    }

    public Rect getVisibleBounds() throws UiObjectNotFoundException {
        Tracer.trace(new Object[0]);
        AccessibilityNodeInfo node = this.findAccessibilityNodeInfo(this.mConfig.getWaitForSelectorTimeout());
        if (node == null) {
            throw new UiObjectNotFoundException(this.mUiSelector.toString());
        }
        return this.getVisibleBounds(node);
    }

    public Rect getBounds() throws UiObjectNotFoundException {
        Tracer.trace(new Object[0]);
        AccessibilityNodeInfo node = this.findAccessibilityNodeInfo(this.mConfig.getWaitForSelectorTimeout());
        if (node == null) {
            throw new UiObjectNotFoundException(this.mUiSelector.toString());
        }
        Rect nodeRect = new Rect();
        node.getBoundsInScreen(nodeRect);
        return nodeRect;
    }

    public boolean waitForExists(long timeout) {
        Tracer.trace(timeout);
        return this.findAccessibilityNodeInfo(timeout) != null;
    }

    public boolean waitUntilGone(long timeout) {
        Tracer.trace(timeout);
        long startMills = SystemClock.uptimeMillis();
        long currentMills = 0L;
        while (currentMills <= timeout) {
            if (this.findAccessibilityNodeInfo(0L) == null) {
                return true;
            }
            currentMills = SystemClock.uptimeMillis() - startMills;
            if (timeout <= 0L) continue;
            SystemClock.sleep((long)1000L);
        }
        return false;
    }

    public boolean exists() {
        Tracer.trace(new Object[0]);
        return this.waitForExists(0L);
    }

    private String safeStringReturn(CharSequence cs) {
        if (cs == null) {
            return "";
        }
        return cs.toString();
    }

    public boolean pinchOut(int percent, int steps) throws UiObjectNotFoundException {
        percent = percent < 0 ? 1 : (percent > 100 ? 100 : percent);
        float percentage = (float)percent / 100.0f;
        AccessibilityNodeInfo node = this.findAccessibilityNodeInfo(this.mConfig.getWaitForSelectorTimeout());
        if (node == null) {
            throw new UiObjectNotFoundException(this.mUiSelector.toString());
        }
        Rect rect = this.getVisibleBounds(node);
        if (rect.width() <= 40) {
            throw new IllegalStateException("Object width is too small for operation");
        }
        Point startPoint1 = new Point(rect.centerX() - 20, rect.centerY());
        Point startPoint2 = new Point(rect.centerX() + 20, rect.centerY());
        Point endPoint1 = new Point(rect.centerX() - (int)((float)(rect.width() / 2) * percentage), rect.centerY());
        Point endPoint2 = new Point(rect.centerX() + (int)((float)(rect.width() / 2) * percentage), rect.centerY());
        return this.performTwoPointerGesture(startPoint1, startPoint2, endPoint1, endPoint2, steps);
    }

    public boolean pinchIn(int percent, int steps) throws UiObjectNotFoundException {
        percent = percent < 0 ? 0 : (percent > 100 ? 100 : percent);
        float percentage = (float)percent / 100.0f;
        AccessibilityNodeInfo node = this.findAccessibilityNodeInfo(this.mConfig.getWaitForSelectorTimeout());
        if (node == null) {
            throw new UiObjectNotFoundException(this.mUiSelector.toString());
        }
        Rect rect = this.getVisibleBounds(node);
        if (rect.width() <= 40) {
            throw new IllegalStateException("Object width is too small for operation");
        }
        Point startPoint1 = new Point(rect.centerX() - (int)((float)(rect.width() / 2) * percentage), rect.centerY());
        Point startPoint2 = new Point(rect.centerX() + (int)((float)(rect.width() / 2) * percentage), rect.centerY());
        Point endPoint1 = new Point(rect.centerX() - 20, rect.centerY());
        Point endPoint2 = new Point(rect.centerX() + 20, rect.centerY());
        return this.performTwoPointerGesture(startPoint1, startPoint2, endPoint1, endPoint2, steps);
    }

    public boolean performTwoPointerGesture(Point startPoint1, Point startPoint2, Point endPoint1, Point endPoint2, int steps) {
        if (steps == 0) {
            steps = 1;
        }
        float stepX1 = (endPoint1.x - startPoint1.x) / steps;
        float stepY1 = (endPoint1.y - startPoint1.y) / steps;
        float stepX2 = (endPoint2.x - startPoint2.x) / steps;
        float stepY2 = (endPoint2.y - startPoint2.y) / steps;
        int eventX1 = startPoint1.x;
        int eventY1 = startPoint1.y;
        int eventX2 = startPoint2.x;
        int eventY2 = startPoint2.y;
        MotionEvent.PointerCoords[] points1 = new MotionEvent.PointerCoords[steps + 2];
        MotionEvent.PointerCoords[] points2 = new MotionEvent.PointerCoords[steps + 2];
        for (int i = 0; i < steps + 1; ++i) {
            MotionEvent.PointerCoords p1 = new MotionEvent.PointerCoords();
            p1.x = eventX1;
            p1.y = eventY1;
            p1.pressure = 1.0f;
            p1.size = 1.0f;
            points1[i] = p1;
            MotionEvent.PointerCoords p2 = new MotionEvent.PointerCoords();
            p2.x = eventX2;
            p2.y = eventY2;
            p2.pressure = 1.0f;
            p2.size = 1.0f;
            points2[i] = p2;
            eventX1 = (int)((float)eventX1 + stepX1);
            eventY1 = (int)((float)eventY1 + stepY1);
            eventX2 = (int)((float)eventX2 + stepX2);
            eventY2 = (int)((float)eventY2 + stepY2);
        }
        MotionEvent.PointerCoords p1 = new MotionEvent.PointerCoords();
        p1.x = endPoint1.x;
        p1.y = endPoint1.y;
        p1.pressure = 1.0f;
        p1.size = 1.0f;
        points1[steps + 1] = p1;
        MotionEvent.PointerCoords p2 = new MotionEvent.PointerCoords();
        p2.x = endPoint2.x;
        p2.y = endPoint2.y;
        p2.pressure = 1.0f;
        p2.size = 1.0f;
        points2[steps + 1] = p2;
        return this.performMultiPointerGesture(points1, points2);
    }

    public boolean performMultiPointerGesture(MotionEvent.PointerCoords[] ... touches) {
        return this.getInteractionController().performMultiPointerGesture(touches);
    }
}

