/*
 * Decompiled with CFR 0.152.
 */
package android.support.test.uiautomator;

import android.support.test.uiautomator.BySelector;
import android.support.test.uiautomator.Direction;
import android.support.test.uiautomator.EventCondition;
import android.support.test.uiautomator.SearchCondition;
import android.support.test.uiautomator.Searchable;
import android.support.test.uiautomator.UiObject2;
import android.support.test.uiautomator.UiObject2Condition;
import android.view.accessibility.AccessibilityEvent;
import java.util.List;
import java.util.regex.Pattern;

public class Until {
    public static SearchCondition<Boolean> gone(final BySelector selector) {
        return new SearchCondition<Boolean>(){

            @Override
            Boolean apply(Searchable container) {
                return !container.hasObject(selector);
            }
        };
    }

    public static SearchCondition<Boolean> hasObject(final BySelector selector) {
        return new SearchCondition<Boolean>(){

            @Override
            Boolean apply(Searchable container) {
                return container.hasObject(selector);
            }
        };
    }

    public static SearchCondition<UiObject2> findObject(final BySelector selector) {
        return new SearchCondition<UiObject2>(){

            @Override
            UiObject2 apply(Searchable container) {
                return container.findObject(selector);
            }
        };
    }

    public static SearchCondition<List<UiObject2>> findObjects(final BySelector selector) {
        return new SearchCondition<List<UiObject2>>(){

            @Override
            List<UiObject2> apply(Searchable container) {
                List<UiObject2> ret = container.findObjects(selector);
                return ret.isEmpty() ? null : ret;
            }
        };
    }

    public static UiObject2Condition<Boolean> checkable(final boolean isCheckable) {
        return new UiObject2Condition<Boolean>(){

            @Override
            Boolean apply(UiObject2 object) {
                return object.isCheckable() == isCheckable;
            }
        };
    }

    public static UiObject2Condition<Boolean> checked(final boolean isChecked) {
        return new UiObject2Condition<Boolean>(){

            @Override
            Boolean apply(UiObject2 object) {
                return object.isChecked() == isChecked;
            }
        };
    }

    public static UiObject2Condition<Boolean> clickable(final boolean isClickable) {
        return new UiObject2Condition<Boolean>(){

            @Override
            Boolean apply(UiObject2 object) {
                return object.isClickable() == isClickable;
            }
        };
    }

    public static UiObject2Condition<Boolean> enabled(final boolean isEnabled) {
        return new UiObject2Condition<Boolean>(){

            @Override
            Boolean apply(UiObject2 object) {
                return object.isEnabled() == isEnabled;
            }
        };
    }

    public static UiObject2Condition<Boolean> focusable(final boolean isFocusable) {
        return new UiObject2Condition<Boolean>(){

            @Override
            Boolean apply(UiObject2 object) {
                return object.isFocusable() == isFocusable;
            }
        };
    }

    public static UiObject2Condition<Boolean> focused(final boolean isFocused) {
        return new UiObject2Condition<Boolean>(){

            @Override
            Boolean apply(UiObject2 object) {
                return object.isFocused() == isFocused;
            }
        };
    }

    public static UiObject2Condition<Boolean> longClickable(final boolean isLongClickable) {
        return new UiObject2Condition<Boolean>(){

            @Override
            Boolean apply(UiObject2 object) {
                return object.isLongClickable() == isLongClickable;
            }
        };
    }

    public static UiObject2Condition<Boolean> scrollable(final boolean isScrollable) {
        return new UiObject2Condition<Boolean>(){

            @Override
            Boolean apply(UiObject2 object) {
                return object.isScrollable() == isScrollable;
            }
        };
    }

    public static UiObject2Condition<Boolean> selected(final boolean isSelected) {
        return new UiObject2Condition<Boolean>(){

            @Override
            Boolean apply(UiObject2 object) {
                return object.isSelected() == isSelected;
            }
        };
    }

    public static UiObject2Condition<Boolean> descMatches(final Pattern regex) {
        return new UiObject2Condition<Boolean>(){

            @Override
            Boolean apply(UiObject2 object) {
                String desc = object.getContentDescription();
                return regex.matcher(desc != null ? desc : "").matches();
            }
        };
    }

    public static UiObject2Condition<Boolean> descMatches(String regex) {
        return Until.descMatches(Pattern.compile(regex));
    }

    public static UiObject2Condition<Boolean> descEquals(String contentDescription) {
        return Until.descMatches(Pattern.compile(Pattern.quote(contentDescription)));
    }

    public static UiObject2Condition<Boolean> descContains(String substring) {
        return Until.descMatches(Pattern.compile(String.format("^.*%s.*$", Pattern.quote(substring))));
    }

    public static UiObject2Condition<Boolean> descStartsWith(String substring) {
        return Until.descMatches(Pattern.compile(String.format("^%s.*$", Pattern.quote(substring))));
    }

    public static UiObject2Condition<Boolean> descEndsWith(String substring) {
        return Until.descMatches(Pattern.compile(String.format("^.*%s$", Pattern.quote(substring))));
    }

    public static UiObject2Condition<Boolean> textMatches(final Pattern regex) {
        return new UiObject2Condition<Boolean>(){

            @Override
            Boolean apply(UiObject2 object) {
                String text = object.getText();
                return regex.matcher(text != null ? text : "").matches();
            }
        };
    }

    public static UiObject2Condition<Boolean> textMatches(String regex) {
        return Until.textMatches(Pattern.compile(regex));
    }

    public static UiObject2Condition<Boolean> textNotEquals(final String text) {
        return new UiObject2Condition<Boolean>(){

            @Override
            Boolean apply(UiObject2 object) {
                return !text.equals(object.getText());
            }
        };
    }

    public static UiObject2Condition<Boolean> textEquals(String text) {
        return Until.textMatches(Pattern.compile(Pattern.quote(text)));
    }

    public static UiObject2Condition<Boolean> textContains(String substring) {
        return Until.textMatches(Pattern.compile(String.format("^.*%s.*$", Pattern.quote(substring))));
    }

    public static UiObject2Condition<Boolean> textStartsWith(String substring) {
        return Until.textMatches(Pattern.compile(String.format("^%s.*$", Pattern.quote(substring))));
    }

    public static UiObject2Condition<Boolean> textEndsWith(String substring) {
        return Until.textMatches(Pattern.compile(String.format("^.*%s$", Pattern.quote(substring))));
    }

    public static EventCondition<Boolean> newWindow() {
        return new EventCondition<Boolean>(){
            private int mMask = 2080;

            @Override
            Boolean apply(AccessibilityEvent event) {
                this.mMask &= ~event.getEventType();
                return this.mMask == 0;
            }

            @Override
            Boolean getResult() {
                return this.mMask == 0;
            }
        };
    }

    public static EventCondition<Boolean> scrollFinished(final Direction direction) {
        return new EventCondition<Boolean>(){
            private Direction mDirection;
            private Boolean mResult;
            {
                this.mDirection = direction;
                this.mResult = null;
            }

            @Override
            Boolean apply(AccessibilityEvent event) {
                block14: {
                    block13: {
                        if (event.getFromIndex() == -1 || event.getToIndex() == -1 || event.getItemCount() == -1) break block13;
                        switch (this.mDirection) {
                            case UP: {
                                this.mResult = event.getFromIndex() == 0;
                                break block14;
                            }
                            case DOWN: {
                                this.mResult = event.getToIndex() == event.getItemCount() - 1;
                                break block14;
                            }
                            case LEFT: {
                                this.mResult = event.getFromIndex() == 0;
                                break block14;
                            }
                            case RIGHT: {
                                this.mResult = event.getToIndex() == event.getItemCount() - 1;
                                break block14;
                            }
                            default: {
                                throw new IllegalArgumentException("Invalid Direction");
                            }
                        }
                    }
                    if (event.getScrollX() != -1 && event.getScrollY() != -1) {
                        switch (this.mDirection) {
                            case UP: {
                                this.mResult = event.getScrollY() == 0;
                                break;
                            }
                            case DOWN: {
                                this.mResult = event.getScrollY() == event.getMaxScrollY();
                                break;
                            }
                            case LEFT: {
                                this.mResult = event.getScrollX() == 0;
                                break;
                            }
                            case RIGHT: {
                                this.mResult = event.getScrollX() == event.getMaxScrollX();
                                break;
                            }
                            default: {
                                throw new IllegalArgumentException("Invalid Direction");
                            }
                        }
                    }
                }
                return Boolean.TRUE.equals(this.mResult);
            }

            @Override
            Boolean getResult() {
                return this.mResult == null || this.mResult != false;
            }
        };
    }
}

