/*
 * Decompiled with CFR 0.152.
 */
package android.support.test.uiautomator;

import android.os.SystemClock;
import android.support.test.uiautomator.Condition;

class WaitMixin<T> {
    private static final long DEFAULT_POLL_INTERVAL = 1000L;
    private T mObject;

    public WaitMixin(T instance) {
        this.mObject = instance;
    }

    public <R> R wait(Condition<? super T, R> condition, long timeout) {
        return this.wait(condition, timeout, 1000L);
    }

    public <R> R wait(Condition<? super T, R> condition, long timeout, long interval) {
        long startTime = SystemClock.uptimeMillis();
        R result = condition.apply(this.mObject);
        long elapsedTime = 0L;
        while ((result == null || result.equals(false)) && elapsedTime < timeout) {
            SystemClock.sleep((long)interval);
            result = condition.apply(this.mObject);
            elapsedTime = SystemClock.uptimeMillis() - startTime;
        }
        return result;
    }
}

