/*
 * Decompiled with CFR 0.152.
 */
package android.support.test.espresso.web.action;

import android.os.Build;
import android.os.Looper;
import android.support.annotation.Nullable;
import android.support.test.espresso.UiController;
import android.support.test.espresso.ViewAction;
import android.support.test.espresso.matcher.ViewMatchers;
import android.support.test.espresso.web.action.JavascriptEvaluation;
import android.support.test.espresso.web.model.Atom;
import android.support.test.espresso.web.model.ElementReference;
import android.support.test.espresso.web.model.Evaluation;
import android.support.test.espresso.web.model.WindowReference;
import android.util.Log;
import android.view.View;
import android.webkit.WebView;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.hamcrest.Matcher;

public final class AtomAction<E>
implements ViewAction {
    private static final String TAG = "AtomAction";
    private final SettableFuture<Evaluation> futureEval = SettableFuture.create();
    private final Atom<E> atom;
    @Nullable
    private final WindowReference window;
    @Nullable
    private final ElementReference element;

    public AtomAction(Atom<E> atom, @Nullable WindowReference window, @Nullable ElementReference element) {
        this.atom = (Atom)Preconditions.checkNotNull(atom);
        this.window = window;
        this.element = element;
    }

    public Matcher<View> getConstraints() {
        return ViewMatchers.isJavascriptEnabled();
    }

    public String getDescription() {
        return String.format("Evaluate Atom: %s in window: %s with element: %s", this.atom, this.window, this.element);
    }

    public void perform(UiController controller, View view) {
        WebView webView = (WebView)view;
        List arguments = (List)Preconditions.checkNotNull(this.atom.getArguments(this.element));
        String script = (String)Preconditions.checkNotNull((Object)this.atom.getScript());
        final ListenableFuture<Evaluation> localEval = JavascriptEvaluation.evaluate(webView, script, arguments, this.window);
        if (null != this.window && Build.VERSION.SDK_INT == 19) {
            Log.w((String)TAG, (String)"WARNING: KitKat does not report when an iframe is loading new content. If you are interacting with content within an iframe and that content is changing (eg: you have just pressed a submit button). Espresso will not be able to block you until the new content has loaded (which it can do on all other API levels). You will need to have some custom polling / synchronization with the iframe in that case.");
        }
        localEval.addListener(new Runnable(){

            @Override
            public void run() {
                try {
                    AtomAction.this.futureEval.set(localEval.get());
                }
                catch (ExecutionException ee) {
                    AtomAction.this.futureEval.setException(ee.getCause());
                }
                catch (InterruptedException ie) {
                    AtomAction.this.futureEval.setException((Throwable)ie);
                }
            }
        }, (Executor)MoreExecutors.sameThreadExecutor());
    }

    public Future<E> getFuture() {
        return Futures.transform(this.futureEval, (Function)new Function<Evaluation, E>(){

            public E apply(Evaluation e) {
                return AtomAction.this.atom.transform(e);
            }
        });
    }

    public E get() throws ExecutionException, InterruptedException {
        Preconditions.checkState((Looper.myLooper() != Looper.getMainLooper() ? 1 : 0) != 0, (Object)"On main thread!");
        return this.getFuture().get();
    }

    public E get(long val, TimeUnit unit) throws ExecutionException, InterruptedException, TimeoutException {
        Preconditions.checkState((Looper.myLooper() != Looper.getMainLooper() ? 1 : 0) != 0, (Object)"On main thread!");
        return this.getFuture().get(val, unit);
    }
}

