/*
 * Decompiled with CFR 0.152.
 */
package android.support.test.espresso.web.action;

import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.support.annotation.Nullable;
import android.support.test.espresso.web.bridge.Conduit;
import android.support.test.espresso.web.bridge.JavaScriptBridge;
import android.support.test.espresso.web.model.Evaluation;
import android.support.test.espresso.web.model.ModelCodec;
import android.support.test.espresso.web.model.WindowReference;
import android.webkit.ValueCallback;
import android.webkit.WebHistoryItem;
import android.webkit.WebView;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.AbstractFuture;
import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.regex.Pattern;

final class JavascriptEvaluation {
    private static final ScriptPreparer SCRIPT_PREPARER;
    private static final AsyncFunction<PreparedScript, String> RAW_EVALUATOR;
    private static final Function<String, Evaluation> DECODE_EVALUATION;
    private static final int SANITIZER_SYNC = 1;
    private static final Handler MAIN_HANDLER;

    private JavascriptEvaluation() {
    }

    static ListenableFuture<Evaluation> evaluate(WebView view, String script, List<? extends Object> arguments, @Nullable WindowReference window) {
        UnpreparedScript unprepared = new UnpreparedScript(view, script, arguments, window);
        SanitizerTask sanitizer = new SanitizerTask(unprepared);
        view.post((Runnable)sanitizer);
        ListenableFuture preparedScript = Futures.transform((ListenableFuture)sanitizer, (Function)SCRIPT_PREPARER);
        ListenableFuture rawEvaluation = Futures.transform((ListenableFuture)preparedScript, RAW_EVALUATOR);
        ListenableFuture parsedEvaluation = Futures.transform((ListenableFuture)rawEvaluation, DECODE_EVALUATION);
        return parsedEvaluation;
    }

    static {
        DECODE_EVALUATION = new Function<String, Evaluation>(){

            public Evaluation apply(String in) {
                return ModelCodec.decodeEvaluation(in);
            }
        };
        MAIN_HANDLER = new Handler(Looper.getMainLooper()){

            public void handleMessage(Message m) {
                switch (m.what) {
                    case 1: {
                        ((SanitizerTask)m.obj).sanitizerSync();
                    }
                }
            }
        };
        if (Build.VERSION.SDK_INT < 19) {
            SCRIPT_PREPARER = new ScriptPreparer(true);
            RAW_EVALUATOR = new AsyncConduitEvaluation();
        } else {
            SCRIPT_PREPARER = new ScriptPreparer(false);
            RAW_EVALUATOR = new AsyncJavascriptEvaluation();
        }
    }

    private static class ValueCallbackFuture<V>
    extends AbstractFuture<V>
    implements ValueCallback<V> {
        private ValueCallbackFuture() {
        }

        public void onReceiveValue(V value) {
            this.set(value);
        }
    }

    private static final class AsyncJavascriptEvaluation
    implements AsyncFunction<PreparedScript, String> {
        private AsyncJavascriptEvaluation() {
        }

        public ListenableFuture<String> apply(final PreparedScript in) {
            if (null != in.conduit) {
                return Futures.immediateFailedFuture((Throwable)new RuntimeException("Conduit script cannot be used"));
            }
            final ValueCallbackFuture result = new ValueCallbackFuture();
            if (Looper.myLooper() == Looper.getMainLooper()) {
                in.view.evaluateJavascript(in.script, result);
            } else {
                in.view.post(new Runnable(){

                    @Override
                    public void run() {
                        in.view.evaluateJavascript(in.script, (ValueCallback)result);
                    }
                });
            }
            return result;
        }
    }

    private static final class AsyncConduitEvaluation
    implements AsyncFunction<PreparedScript, String> {
        private AsyncConduitEvaluation() {
        }

        public ListenableFuture<String> apply(final PreparedScript in) {
            if (null == in.conduit) {
                return Futures.immediateFailedFuture((Throwable)new RuntimeException("Not a conduit script!"));
            }
            if (Looper.myLooper() == Looper.getMainLooper()) {
                in.view.loadUrl(in.script);
            } else {
                in.view.post(new Runnable(){

                    @Override
                    public void run() {
                        in.view.loadUrl(in.script);
                    }
                });
            }
            return in.conduit.getResult();
        }
    }

    private static final class ScriptPreparer
    implements Function<UnpreparedScript, PreparedScript> {
        private final boolean conduitize;
        private static final Pattern FUNCTION_PATTERN = Pattern.compile("^\\s*function\\s*\\w*\\s*\\(.*\\}\\s*$", 40);

        public ScriptPreparer(boolean conduitize) {
            this.conduitize = conduitize;
        }

        public PreparedScript apply(UnpreparedScript unprepared) {
            StringBuilder atomized = this.atomize(unprepared.script, unprepared.args, unprepared.window);
            Conduit conduit = null;
            if (this.conduitize) {
                conduit = JavaScriptBridge.makeConduit();
                atomized = conduit.wrapScriptInConduit(atomized).insert(0, "javascript:");
            }
            return new PreparedScript(unprepared.view, atomized.toString(), conduit);
        }

        private StringBuilder atomize(String script, List<? extends Object> args, WindowReference windowReference) {
            int guessedSize = "function(){return(function(){function g(a){var b=typeof a;if(\"object\"==b)if(a){if(a instanceof Array)return\"array\";if(a instanceof Object)return b;var c=Object.prototype.toString.call(a);if(\"[object Window]\"==c)return\"object\";if(\"[object Array]\"==c||\"number\"==typeof a.length&&\"undefined\"!=typeof a.splice&&\"undefined\"!=typeof a.propertyIsEnumerable&&!a.propertyIsEnumerable(\"splice\"))return\"array\";if(\"[object Function]\"==c||\"undefined\"!=typeof a.call&&\"undefined\"!=typeof a.propertyIsEnumerable&&!a.propertyIsEnumerable(\"call\"))return\"function\"}else return\"null\";\nelse if(\"function\"==b&&\"undefined\"==typeof a.call)return\"object\";return b}function k(a){var b=g(a);return\"array\"==b||\"object\"==b&&\"number\"==typeof a.length}function n(a){var b=typeof a;return\"object\"==b&&null!=a||\"function\"==b}function p(a,b,c){return a.call.apply(a.bind,arguments)}\nfunction q(a,b,c){if(!a)throw Error();if(2<arguments.length){var d=Array.prototype.slice.call(arguments,2);return function(){var c=Array.prototype.slice.call(arguments);Array.prototype.unshift.apply(c,d);return a.apply(b,c)}}return function(){return a.apply(b,arguments)}}function r(a,b,c){r=Function.prototype.bind&&-1!=Function.prototype.bind.toString().indexOf(\"native code\")?p:q;return r.apply(null,arguments)}var t=Date.now||function(){return+new Date};\nFunction.prototype.bind=Function.prototype.bind||function(a,b){if(1<arguments.length){var c=Array.prototype.slice.call(arguments,1);c.unshift(this,a);return r.apply(null,c)}return r(this,a)};var u=String.prototype.trim?function(a){return a.trim()}:function(a){return a.replace(/^[\\s\\xa0]+|[\\s\\xa0]+$/g,\"\")};function v(a,b){return a<b?-1:a>b?1:0};function w(a,b){for(var c=a.length,d=Array(c),f=\"string\"==typeof a?a.split(\"\"):a,e=0;e<c;e++)e in f&&(d[e]=b.call(void 0,f[e],e,a));return d};function x(a,b){var c={},d;for(d in a)b.call(void 0,a[d],d,a)&&(c[d]=a[d]);return c}function A(a,b){var c={},d;for(d in a)c[d]=b.call(void 0,a[d],d,a);return c}function B(a,b){for(var c in a)if(b.call(void 0,a[c],c,a))return c};var C;a:{var D=this.navigator;if(D){var E=D.userAgent;if(E){C=E;break a}}C=\"\"};/*xxx_rpl_lic*/\nvar F=window;/*xxx_rpl_lic*/\nfunction G(a,b){this.code=a;this.b=H[a]||\"unknown error\";this.message=b||\"\";var c=this.b.replace(/((?:^|\\s+)[a-z])/g,function(a){return a.toUpperCase().replace(/^[\\s\\xa0]+/g,\"\")}),d=c.length-5;if(0>d||c.indexOf(\"Error\",d)!=d)c+=\"Error\";this.name=c;c=Error(this.message);c.name=this.name;this.stack=c.stack||\"\"}\n(function(){var a=Error;function b(){}b.prototype=a.prototype;G.c=a.prototype;G.prototype=new b;G.prototype.constructor=G;G.b=function(b,d,f){for(var e=Array(arguments.length-2),l=2;l<arguments.length;l++)e[l-2]=arguments[l];return a.prototype[d].apply(b,e)}})();\nvar H={15:\"element not selectable\",11:\"element not visible\",31:\"ime engine activation failed\",30:\"ime not available\",24:\"invalid cookie domain\",29:\"invalid element coordinates\",12:\"invalid element state\",32:\"invalid selector\",51:\"invalid selector\",52:\"invalid selector\",17:\"javascript error\",405:\"unsupported operation\",34:\"move target out of bounds\",27:\"no such alert\",7:\"no such element\",8:\"no such frame\",23:\"no such window\",28:\"script timeout\",33:\"session not created\",10:\"stale element reference\",\n0:\"success\",21:\"timeout\",25:\"unable to set cookie\",26:\"unexpected alert open\",13:\"unknown error\",9:\"unknown command\"};G.prototype.toString=function(){return this.name+\": \"+this.message};function I(){}\nfunction J(a,b,c){if(null==b)c.push(\"null\");else{if(\"object\"==typeof b){if(\"array\"==g(b)){var d=b;b=d.length;c.push(\"[\");for(var f=\"\",e=0;e<b;e++)c.push(f),J(a,d[e],c),f=\",\";c.push(\"]\");return}if(b instanceof String||b instanceof Number||b instanceof Boolean)b=b.valueOf();else{c.push(\"{\");f=\"\";for(d in b)Object.prototype.hasOwnProperty.call(b,d)&&(e=b[d],\"function\"!=typeof e&&(c.push(f),K(d,c),c.push(\":\"),J(a,e,c),f=\",\"));c.push(\"}\");return}}switch(typeof b){case \"string\":K(b,c);break;case \"number\":c.push(isFinite(b)&&\n!isNaN(b)?b:\"null\");break;case \"boolean\":c.push(b);break;case \"function\":break;default:throw Error(\"Unknown type: \"+typeof b);}}}var L={'\"':'\\\\\"',\"\\\\\":\"\\\\\\\\\",\"/\":\"\\\\/\",\"\\b\":\"\\\\b\",\"\\f\":\"\\\\f\",\"\\n\":\"\\\\n\",\"\\r\":\"\\\\r\",\"\\t\":\"\\\\t\",\"\\x0B\":\"\\\\u000b\"},M=/\\uffff/.test(\"\\uffff\")?/[\\\\\\\"\\x00-\\x1f\\x7f-\\uffff]/g:/[\\\\\\\"\\x00-\\x1f\\x7f-\\xff]/g;function K(a,b){b.push('\"',a.replace(M,function(a){var b=L[a];b||(b=\"\\\\u\"+(a.charCodeAt(0)|65536).toString(16).substr(1),L[a]=b);return b}),'\"')};function N(a){return(a=a.exec(C))?a[1]:\"\"}N(/Android\\s+([0-9.]+)/)||N(/Version\\/([0-9.]+)/);/*xxx_rpl_lic*/\nfunction O(a){var b=0,c=u(String(aa)).split(\".\");a=u(String(a)).split(\".\");for(var d=Math.max(c.length,a.length),f=0;0==b&&f<d;f++){var e=c[f]||\"\",l=a[f]||\"\",y=RegExp(\"(\\\\d*)(\\\\D*)\",\"g\"),z=RegExp(\"(\\\\d*)(\\\\D*)\",\"g\");do{var h=y.exec(e)||[\"\",\"\",\"\"],m=z.exec(l)||[\"\",\"\",\"\"];if(0==h[0].length&&0==m[0].length)break;b=v(0==h[1].length?0:parseInt(h[1],10),0==m[1].length?0:parseInt(m[1],10))||v(0==h[2].length,0==m[2].length)||v(h[2],m[2])}while(0==b)}}var P=/Android\\s+([0-9\\.]+)/.exec(C),aa=P?P[1]:\"0\";O(2.3);\nO(4);/*xxx_rpl_lic*/\n/*xxx_rpl_lic*/\n/*xxx_rpl_lic*/\nfunction Q(a){switch(g(a)){case \"string\":case \"number\":case \"boolean\":return a;case \"function\":return a.toString();case \"array\":return w(a,Q);case \"object\":if(\"nodeType\"in a&&(1==a.nodeType||9==a.nodeType)){var b={};b.ELEMENT=R(a);return b}if(\"document\"in a)return b={},b.WINDOW=R(a),b;if(k(a))return w(a,Q);a=x(a,function(a,b){return\"number\"==typeof b||\"string\"==typeof b});return A(a,Q);default:return null}}\nfunction S(a,b){return\"array\"==g(a)?w(a,function(a){return S(a,b)}):n(a)?\"function\"==typeof a?a:\"ELEMENT\"in a?T(a.ELEMENT,b):\"WINDOW\"in a?T(a.WINDOW,b):A(a,function(a){return S(a,b)}):a}function U(a){a=a||document;var b=a.$wdc_;b||(b=a.$wdc_={},b.a=t());b.a||(b.a=t());return b}function R(a){var b=U(a.ownerDocument),c=B(b,function(b){return b==a});c||(c=\":wdc:\"+b.a++,b[c]=a);return c}\nfunction T(a,b){a=decodeURIComponent(a);var c=b||document,d=U(c);if(!(a in d))throw new G(10,\"Element does not exist in cache\");var f=d[a];if(\"setInterval\"in f){if(f.closed)throw delete d[a],new G(23,\"Window has been closed.\");return f}for(var e=f;e;){if(e==c.documentElement)return f;e=e.parentNode}delete d[a];throw new G(10,\"Element is no longer attached to the DOM\");};function V(a,b,c,d){d=d||F;var f;try{a:{var e=a;if(\"string\"==typeof e)try{a=new d.Function(e);break a}catch(l){throw l;}a=d==window?e:new d.Function(\"return (\"+e+\").apply(null,arguments);\")}var y=S(b,d.document),z=a.apply(null,y);f={status:0,value:Q(z)}}catch(h){f={status:\"code\"in h?h.code:13,value:{message:h.message}}}c&&(a=[],J(new I,f,a),f=a.join(\"\"));return f}var W=[\"_\"],X=this;W[0]in X||!X.execScript||X.execScript(\"var \"+W[0]);\nfor(var Y;W.length&&(Y=W.shift());){var Z;if(Z=!W.length)Z=void 0!==V;Z?X[Y]=V:X[Y]?X=X[Y]:X=X[Y]={}};;return this._.apply(null,arguments);}).apply({navigator:typeof window!=\"undefined\"?window.navigator:null},arguments);}\n".length() + script.length() + 1024;
            if (windowReference != null) {
                guessedSize += "function(){return(function(){function f(a,c,b){return a.call.apply(a.bind,arguments)}function h(a,c,b){if(!a)throw Error();if(2<arguments.length){var e=Array.prototype.slice.call(arguments,2);return function(){var d=Array.prototype.slice.call(arguments);Array.prototype.unshift.apply(d,e);return a.apply(c,d)}}return function(){return a.apply(c,arguments)}}function n(a,c,b){n=Function.prototype.bind&&-1!=Function.prototype.bind.toString().indexOf(\"native code\")?f:h;return n.apply(null,arguments)}var p=Date.now||function(){return+new Date};\nFunction.prototype.bind=Function.prototype.bind||function(a,c){if(1<arguments.length){var b=Array.prototype.slice.call(arguments,1);b.unshift(this,a);return n.apply(null,b)}return n(this,a)};var q=String.prototype.trim?function(a){return a.trim()}:function(a){return a.replace(/^[\\s\\xa0]+|[\\s\\xa0]+$/g,\"\")};function r(a,c){return a<c?-1:a>c?1:0};var t;a:{var u=this.navigator;if(u){var v=u.userAgent;if(v){t=v;break a}}t=\"\"};/*xxx_rpl_lic*/\n/*xxx_rpl_lic*/\nfunction w(a,c){this.code=a;this.a=x[a]||\"unknown error\";this.message=c||\"\";var b=this.a.replace(/((?:^|\\s+)[a-z])/g,function(a){return a.toUpperCase().replace(/^[\\s\\xa0]+/g,\"\")}),e=b.length-5;if(0>e||b.indexOf(\"Error\",e)!=e)b+=\"Error\";this.name=b;b=Error(this.message);b.name=this.name;this.stack=b.stack||\"\"}\n(function(){var a=Error;function c(){}c.prototype=a.prototype;w.c=a.prototype;w.prototype=new c;w.prototype.constructor=w;w.a=function(b,c,d){for(var g=Array(arguments.length-2),k=2;k<arguments.length;k++)g[k-2]=arguments[k];return a.prototype[c].apply(b,g)}})();\nvar x={15:\"element not selectable\",11:\"element not visible\",31:\"ime engine activation failed\",30:\"ime not available\",24:\"invalid cookie domain\",29:\"invalid element coordinates\",12:\"invalid element state\",32:\"invalid selector\",51:\"invalid selector\",52:\"invalid selector\",17:\"javascript error\",405:\"unsupported operation\",34:\"move target out of bounds\",27:\"no such alert\",7:\"no such element\",8:\"no such frame\",23:\"no such window\",28:\"script timeout\",33:\"session not created\",10:\"stale element reference\",\n0:\"success\",21:\"timeout\",25:\"unable to set cookie\",26:\"unexpected alert open\",13:\"unknown error\",9:\"unknown command\"};w.prototype.toString=function(){return this.name+\": \"+this.message};function y(a){return(a=a.exec(t))?a[1]:\"\"}y(/Android\\s+([0-9.]+)/)||y(/Version\\/([0-9.]+)/);/*xxx_rpl_lic*/\nfunction z(a){var c=0,b=q(String(A)).split(\".\");a=q(String(a)).split(\".\");for(var e=Math.max(b.length,a.length),d=0;0==c&&d<e;d++){var g=b[d]||\"\",k=a[d]||\"\",H=RegExp(\"(\\\\d*)(\\\\D*)\",\"g\"),I=RegExp(\"(\\\\d*)(\\\\D*)\",\"g\");do{var l=H.exec(g)||[\"\",\"\",\"\"],m=I.exec(k)||[\"\",\"\",\"\"];if(0==l[0].length&&0==m[0].length)break;c=r(0==l[1].length?0:parseInt(l[1],10),0==m[1].length?0:parseInt(m[1],10))||r(0==l[2].length,0==m[2].length)||r(l[2],m[2])}while(0==c)}}var B=/Android\\s+([0-9\\.]+)/.exec(t),A=B?B[1]:\"0\";z(2.3);\nz(4);/*xxx_rpl_lic*/\n/*xxx_rpl_lic*/\n/*xxx_rpl_lic*/\nfunction C(a,c){a=decodeURIComponent(a);var b=c||document,e;e=b||document;var d=e.$wdc_;d||(d=e.$wdc_={},d.b=p());d.b||(d.b=p());e=d;if(!(a in e))throw new w(10,\"Element does not exist in cache\");d=e[a];if(\"setInterval\"in d){if(d.closed)throw delete e[a],new w(23,\"Window has been closed.\");return d}for(var g=d;g;){if(g==b.documentElement)return d;g=g.parentNode}delete e[a];throw new w(10,\"Element is no longer attached to the DOM\");}var D=[\"_\"],E=this;D[0]in E||!E.execScript||E.execScript(\"var \"+D[0]);\nfor(var F;D.length&&(F=D.shift());){var G;if(G=!D.length)G=void 0!==C;G?E[F]=C:E[F]?E=E[F]:E=E[F]={}};;return this._.apply(null,arguments);}).apply({navigator:typeof window!=\"undefined\"?window.navigator:null},arguments);}\n".length();
            }
            StringBuilder toExecute = new StringBuilder(guessedSize).append("var my_wind = ");
            if (windowReference != null) {
                toExecute.append("(").append("function(){return(function(){function f(a,c,b){return a.call.apply(a.bind,arguments)}function h(a,c,b){if(!a)throw Error();if(2<arguments.length){var e=Array.prototype.slice.call(arguments,2);return function(){var d=Array.prototype.slice.call(arguments);Array.prototype.unshift.apply(d,e);return a.apply(c,d)}}return function(){return a.apply(c,arguments)}}function n(a,c,b){n=Function.prototype.bind&&-1!=Function.prototype.bind.toString().indexOf(\"native code\")?f:h;return n.apply(null,arguments)}var p=Date.now||function(){return+new Date};\nFunction.prototype.bind=Function.prototype.bind||function(a,c){if(1<arguments.length){var b=Array.prototype.slice.call(arguments,1);b.unshift(this,a);return n.apply(null,b)}return n(this,a)};var q=String.prototype.trim?function(a){return a.trim()}:function(a){return a.replace(/^[\\s\\xa0]+|[\\s\\xa0]+$/g,\"\")};function r(a,c){return a<c?-1:a>c?1:0};var t;a:{var u=this.navigator;if(u){var v=u.userAgent;if(v){t=v;break a}}t=\"\"};/*xxx_rpl_lic*/\n/*xxx_rpl_lic*/\nfunction w(a,c){this.code=a;this.a=x[a]||\"unknown error\";this.message=c||\"\";var b=this.a.replace(/((?:^|\\s+)[a-z])/g,function(a){return a.toUpperCase().replace(/^[\\s\\xa0]+/g,\"\")}),e=b.length-5;if(0>e||b.indexOf(\"Error\",e)!=e)b+=\"Error\";this.name=b;b=Error(this.message);b.name=this.name;this.stack=b.stack||\"\"}\n(function(){var a=Error;function c(){}c.prototype=a.prototype;w.c=a.prototype;w.prototype=new c;w.prototype.constructor=w;w.a=function(b,c,d){for(var g=Array(arguments.length-2),k=2;k<arguments.length;k++)g[k-2]=arguments[k];return a.prototype[c].apply(b,g)}})();\nvar x={15:\"element not selectable\",11:\"element not visible\",31:\"ime engine activation failed\",30:\"ime not available\",24:\"invalid cookie domain\",29:\"invalid element coordinates\",12:\"invalid element state\",32:\"invalid selector\",51:\"invalid selector\",52:\"invalid selector\",17:\"javascript error\",405:\"unsupported operation\",34:\"move target out of bounds\",27:\"no such alert\",7:\"no such element\",8:\"no such frame\",23:\"no such window\",28:\"script timeout\",33:\"session not created\",10:\"stale element reference\",\n0:\"success\",21:\"timeout\",25:\"unable to set cookie\",26:\"unexpected alert open\",13:\"unknown error\",9:\"unknown command\"};w.prototype.toString=function(){return this.name+\": \"+this.message};function y(a){return(a=a.exec(t))?a[1]:\"\"}y(/Android\\s+([0-9.]+)/)||y(/Version\\/([0-9.]+)/);/*xxx_rpl_lic*/\nfunction z(a){var c=0,b=q(String(A)).split(\".\");a=q(String(a)).split(\".\");for(var e=Math.max(b.length,a.length),d=0;0==c&&d<e;d++){var g=b[d]||\"\",k=a[d]||\"\",H=RegExp(\"(\\\\d*)(\\\\D*)\",\"g\"),I=RegExp(\"(\\\\d*)(\\\\D*)\",\"g\");do{var l=H.exec(g)||[\"\",\"\",\"\"],m=I.exec(k)||[\"\",\"\",\"\"];if(0==l[0].length&&0==m[0].length)break;c=r(0==l[1].length?0:parseInt(l[1],10),0==m[1].length?0:parseInt(m[1],10))||r(0==l[2].length,0==m[2].length)||r(l[2],m[2])}while(0==c)}}var B=/Android\\s+([0-9\\.]+)/.exec(t),A=B?B[1]:\"0\";z(2.3);\nz(4);/*xxx_rpl_lic*/\n/*xxx_rpl_lic*/\n/*xxx_rpl_lic*/\nfunction C(a,c){a=decodeURIComponent(a);var b=c||document,e;e=b||document;var d=e.$wdc_;d||(d=e.$wdc_={},d.b=p());d.b||(d.b=p());e=d;if(!(a in e))throw new w(10,\"Element does not exist in cache\");d=e[a];if(\"setInterval\"in d){if(d.closed)throw delete e[a],new w(23,\"Window has been closed.\");return d}for(var g=d;g;){if(g==b.documentElement)return d;g=g.parentNode}delete e[a];throw new w(10,\"Element is no longer attached to the DOM\");}var D=[\"_\"],E=this;D[0]in E||!E.execScript||E.execScript(\"var \"+D[0]);\nfor(var F;D.length&&(F=D.shift());){var G;if(G=!D.length)G=void 0!==C;G?E[F]=C:E[F]?E=E[F]:E=E[F]={}};;return this._.apply(null,arguments);}).apply({navigator:typeof window!=\"undefined\"?window.navigator:null},arguments);}\n").append(")(").append(ModelCodec.encode(windowReference)).append("[\"WINDOW\"]);");
            } else {
                toExecute.append("null;");
            }
            toExecute.append("return (").append("function(){return(function(){function g(a){var b=typeof a;if(\"object\"==b)if(a){if(a instanceof Array)return\"array\";if(a instanceof Object)return b;var c=Object.prototype.toString.call(a);if(\"[object Window]\"==c)return\"object\";if(\"[object Array]\"==c||\"number\"==typeof a.length&&\"undefined\"!=typeof a.splice&&\"undefined\"!=typeof a.propertyIsEnumerable&&!a.propertyIsEnumerable(\"splice\"))return\"array\";if(\"[object Function]\"==c||\"undefined\"!=typeof a.call&&\"undefined\"!=typeof a.propertyIsEnumerable&&!a.propertyIsEnumerable(\"call\"))return\"function\"}else return\"null\";\nelse if(\"function\"==b&&\"undefined\"==typeof a.call)return\"object\";return b}function k(a){var b=g(a);return\"array\"==b||\"object\"==b&&\"number\"==typeof a.length}function n(a){var b=typeof a;return\"object\"==b&&null!=a||\"function\"==b}function p(a,b,c){return a.call.apply(a.bind,arguments)}\nfunction q(a,b,c){if(!a)throw Error();if(2<arguments.length){var d=Array.prototype.slice.call(arguments,2);return function(){var c=Array.prototype.slice.call(arguments);Array.prototype.unshift.apply(c,d);return a.apply(b,c)}}return function(){return a.apply(b,arguments)}}function r(a,b,c){r=Function.prototype.bind&&-1!=Function.prototype.bind.toString().indexOf(\"native code\")?p:q;return r.apply(null,arguments)}var t=Date.now||function(){return+new Date};\nFunction.prototype.bind=Function.prototype.bind||function(a,b){if(1<arguments.length){var c=Array.prototype.slice.call(arguments,1);c.unshift(this,a);return r.apply(null,c)}return r(this,a)};var u=String.prototype.trim?function(a){return a.trim()}:function(a){return a.replace(/^[\\s\\xa0]+|[\\s\\xa0]+$/g,\"\")};function v(a,b){return a<b?-1:a>b?1:0};function w(a,b){for(var c=a.length,d=Array(c),f=\"string\"==typeof a?a.split(\"\"):a,e=0;e<c;e++)e in f&&(d[e]=b.call(void 0,f[e],e,a));return d};function x(a,b){var c={},d;for(d in a)b.call(void 0,a[d],d,a)&&(c[d]=a[d]);return c}function A(a,b){var c={},d;for(d in a)c[d]=b.call(void 0,a[d],d,a);return c}function B(a,b){for(var c in a)if(b.call(void 0,a[c],c,a))return c};var C;a:{var D=this.navigator;if(D){var E=D.userAgent;if(E){C=E;break a}}C=\"\"};/*xxx_rpl_lic*/\nvar F=window;/*xxx_rpl_lic*/\nfunction G(a,b){this.code=a;this.b=H[a]||\"unknown error\";this.message=b||\"\";var c=this.b.replace(/((?:^|\\s+)[a-z])/g,function(a){return a.toUpperCase().replace(/^[\\s\\xa0]+/g,\"\")}),d=c.length-5;if(0>d||c.indexOf(\"Error\",d)!=d)c+=\"Error\";this.name=c;c=Error(this.message);c.name=this.name;this.stack=c.stack||\"\"}\n(function(){var a=Error;function b(){}b.prototype=a.prototype;G.c=a.prototype;G.prototype=new b;G.prototype.constructor=G;G.b=function(b,d,f){for(var e=Array(arguments.length-2),l=2;l<arguments.length;l++)e[l-2]=arguments[l];return a.prototype[d].apply(b,e)}})();\nvar H={15:\"element not selectable\",11:\"element not visible\",31:\"ime engine activation failed\",30:\"ime not available\",24:\"invalid cookie domain\",29:\"invalid element coordinates\",12:\"invalid element state\",32:\"invalid selector\",51:\"invalid selector\",52:\"invalid selector\",17:\"javascript error\",405:\"unsupported operation\",34:\"move target out of bounds\",27:\"no such alert\",7:\"no such element\",8:\"no such frame\",23:\"no such window\",28:\"script timeout\",33:\"session not created\",10:\"stale element reference\",\n0:\"success\",21:\"timeout\",25:\"unable to set cookie\",26:\"unexpected alert open\",13:\"unknown error\",9:\"unknown command\"};G.prototype.toString=function(){return this.name+\": \"+this.message};function I(){}\nfunction J(a,b,c){if(null==b)c.push(\"null\");else{if(\"object\"==typeof b){if(\"array\"==g(b)){var d=b;b=d.length;c.push(\"[\");for(var f=\"\",e=0;e<b;e++)c.push(f),J(a,d[e],c),f=\",\";c.push(\"]\");return}if(b instanceof String||b instanceof Number||b instanceof Boolean)b=b.valueOf();else{c.push(\"{\");f=\"\";for(d in b)Object.prototype.hasOwnProperty.call(b,d)&&(e=b[d],\"function\"!=typeof e&&(c.push(f),K(d,c),c.push(\":\"),J(a,e,c),f=\",\"));c.push(\"}\");return}}switch(typeof b){case \"string\":K(b,c);break;case \"number\":c.push(isFinite(b)&&\n!isNaN(b)?b:\"null\");break;case \"boolean\":c.push(b);break;case \"function\":break;default:throw Error(\"Unknown type: \"+typeof b);}}}var L={'\"':'\\\\\"',\"\\\\\":\"\\\\\\\\\",\"/\":\"\\\\/\",\"\\b\":\"\\\\b\",\"\\f\":\"\\\\f\",\"\\n\":\"\\\\n\",\"\\r\":\"\\\\r\",\"\\t\":\"\\\\t\",\"\\x0B\":\"\\\\u000b\"},M=/\\uffff/.test(\"\\uffff\")?/[\\\\\\\"\\x00-\\x1f\\x7f-\\uffff]/g:/[\\\\\\\"\\x00-\\x1f\\x7f-\\xff]/g;function K(a,b){b.push('\"',a.replace(M,function(a){var b=L[a];b||(b=\"\\\\u\"+(a.charCodeAt(0)|65536).toString(16).substr(1),L[a]=b);return b}),'\"')};function N(a){return(a=a.exec(C))?a[1]:\"\"}N(/Android\\s+([0-9.]+)/)||N(/Version\\/([0-9.]+)/);/*xxx_rpl_lic*/\nfunction O(a){var b=0,c=u(String(aa)).split(\".\");a=u(String(a)).split(\".\");for(var d=Math.max(c.length,a.length),f=0;0==b&&f<d;f++){var e=c[f]||\"\",l=a[f]||\"\",y=RegExp(\"(\\\\d*)(\\\\D*)\",\"g\"),z=RegExp(\"(\\\\d*)(\\\\D*)\",\"g\");do{var h=y.exec(e)||[\"\",\"\",\"\"],m=z.exec(l)||[\"\",\"\",\"\"];if(0==h[0].length&&0==m[0].length)break;b=v(0==h[1].length?0:parseInt(h[1],10),0==m[1].length?0:parseInt(m[1],10))||v(0==h[2].length,0==m[2].length)||v(h[2],m[2])}while(0==b)}}var P=/Android\\s+([0-9\\.]+)/.exec(C),aa=P?P[1]:\"0\";O(2.3);\nO(4);/*xxx_rpl_lic*/\n/*xxx_rpl_lic*/\n/*xxx_rpl_lic*/\nfunction Q(a){switch(g(a)){case \"string\":case \"number\":case \"boolean\":return a;case \"function\":return a.toString();case \"array\":return w(a,Q);case \"object\":if(\"nodeType\"in a&&(1==a.nodeType||9==a.nodeType)){var b={};b.ELEMENT=R(a);return b}if(\"document\"in a)return b={},b.WINDOW=R(a),b;if(k(a))return w(a,Q);a=x(a,function(a,b){return\"number\"==typeof b||\"string\"==typeof b});return A(a,Q);default:return null}}\nfunction S(a,b){return\"array\"==g(a)?w(a,function(a){return S(a,b)}):n(a)?\"function\"==typeof a?a:\"ELEMENT\"in a?T(a.ELEMENT,b):\"WINDOW\"in a?T(a.WINDOW,b):A(a,function(a){return S(a,b)}):a}function U(a){a=a||document;var b=a.$wdc_;b||(b=a.$wdc_={},b.a=t());b.a||(b.a=t());return b}function R(a){var b=U(a.ownerDocument),c=B(b,function(b){return b==a});c||(c=\":wdc:\"+b.a++,b[c]=a);return c}\nfunction T(a,b){a=decodeURIComponent(a);var c=b||document,d=U(c);if(!(a in d))throw new G(10,\"Element does not exist in cache\");var f=d[a];if(\"setInterval\"in f){if(f.closed)throw delete d[a],new G(23,\"Window has been closed.\");return f}for(var e=f;e;){if(e==c.documentElement)return f;e=e.parentNode}delete d[a];throw new G(10,\"Element is no longer attached to the DOM\");};function V(a,b,c,d){d=d||F;var f;try{a:{var e=a;if(\"string\"==typeof e)try{a=new d.Function(e);break a}catch(l){throw l;}a=d==window?e:new d.Function(\"return (\"+e+\").apply(null,arguments);\")}var y=S(b,d.document),z=a.apply(null,y);f={status:0,value:Q(z)}}catch(h){f={status:\"code\"in h?h.code:13,value:{message:h.message}}}c&&(a=[],J(new I,f,a),f=a.join(\"\"));return f}var W=[\"_\"],X=this;W[0]in X||!X.execScript||X.execScript(\"var \"+W[0]);\nfor(var Y;W.length&&(Y=W.shift());){var Z;if(Z=!W.length)Z=void 0!==V;Z?X[Y]=V:X[Y]?X=X[Y]:X=X[Y]={}};;return this._.apply(null,arguments);}).apply({navigator:typeof window!=\"undefined\"?window.navigator:null},arguments);}\n").append(")(");
            this.escapeAndQuote(toExecute, script).append(",").append(ModelCodec.encode(args)).append(",").append(this.conduitize).append(",").append("my_wind)");
            return this.wrapInFunction(toExecute);
        }

        private StringBuilder wrapInFunction(StringBuilder script) {
            script.insert(0, "(function(){").append("})()");
            return script;
        }

        static boolean isFunctionDefinition(String script) {
            return FUNCTION_PATTERN.matcher(script).matches();
        }

        private StringBuilder escapeAndQuote(StringBuilder scriptBuffer, String toWrap) {
            scriptBuffer.append("\"");
            boolean isFunction = ScriptPreparer.isFunctionDefinition(toWrap);
            if (isFunction) {
                scriptBuffer.append("return (");
            }
            block7: for (int i = 0; i < toWrap.length(); ++i) {
                char c = toWrap.charAt(i);
                switch (c) {
                    case '\"': 
                    case '\'': 
                    case '\\': {
                        scriptBuffer.append('\\').append(c);
                        continue block7;
                    }
                    case '\n': {
                        scriptBuffer.append("\\n");
                        continue block7;
                    }
                    case '\r': {
                        scriptBuffer.append("\\r");
                        continue block7;
                    }
                    case '\u2028': {
                        scriptBuffer.append("\\u2028");
                        continue block7;
                    }
                    case '\u2029': {
                        scriptBuffer.append("\\u2029");
                        continue block7;
                    }
                    default: {
                        scriptBuffer.append(c);
                    }
                }
            }
            if (isFunction) {
                scriptBuffer.append(").apply(null,arguments);");
            }
            scriptBuffer.append("\"");
            return scriptBuffer;
        }
    }

    private static class PreparedScript {
        private final WebView view;
        private final String script;
        @Nullable
        private final Conduit conduit;

        PreparedScript(WebView view, String script, @Nullable Conduit conduit) {
            this.view = (WebView)Preconditions.checkNotNull((Object)view);
            this.script = (String)Preconditions.checkNotNull((Object)script);
            this.conduit = conduit;
        }
    }

    private static class UnpreparedScript {
        private final WebView view;
        private final String script;
        private final List<? extends Object> args;
        @Nullable
        private final WindowReference window;

        UnpreparedScript(WebView view, String script, List<? extends Object> args, @Nullable WindowReference window) {
            this.view = (WebView)Preconditions.checkNotNull((Object)view);
            this.script = (String)Preconditions.checkNotNull((Object)script);
            this.args = (List)Preconditions.checkNotNull(args);
            this.window = window;
        }
    }

    private static class SanitizerTask
    extends AbstractFuture<UnpreparedScript>
    implements Runnable {
        private static final String DOC_ELEMENT_PRESENT = "return document.documentElement != null && document.readyState === 'complete'";
        private static final int DELAY = 100;
        private final UnpreparedScript unprepared;
        private String sanityMessage = "";
        private int count;

        public SanitizerTask(UnpreparedScript unprepared) {
            this.unprepared = (UnpreparedScript)Preconditions.checkNotNull((Object)unprepared);
            this.count = 0;
        }

        @Override
        public void run() {
            if (Looper.myLooper() != Looper.getMainLooper()) {
                this.unprepared.view.post((Runnable)this);
            } else {
                try {
                    this.innerSanity();
                }
                catch (RuntimeException re) {
                    this.setException(re);
                }
            }
        }

        void sanitizerSync() {
            if (this.isWebViewSane()) {
                this.set(this.unprepared);
            } else {
                this.unprepared.view.post((Runnable)this);
            }
        }

        private void innerSanity() {
            ++this.count;
            Preconditions.checkState((this.count < 250 ? 1 : 0) != 0, (String)"Waited over: %s millis but webview never went sane: %s", (Object[])new Object[]{25000, this.sanityMessage});
            if (this.isWebViewSane()) {
                PreparedScript docCheckScript = SCRIPT_PREPARER.apply(new UnpreparedScript(this.unprepared.view, DOC_ELEMENT_PRESENT, Collections.EMPTY_LIST, this.unprepared.window));
                ListenableFuture futureRaw = null;
                try {
                    futureRaw = RAW_EVALUATOR.apply((Object)docCheckScript);
                }
                catch (Exception e) {
                    this.setException(e);
                    return;
                }
                final ListenableFuture futureParsed = Futures.transform((ListenableFuture)futureRaw, (Function)DECODE_EVALUATION);
                futureParsed.addListener(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Evaluation eval = (Evaluation)futureParsed.get();
                            if (eval.getStatus() == 0) {
                                if (((Boolean)eval.getValue()).booleanValue()) {
                                    if (Build.VERSION.SDK_INT == 10) {
                                        SanitizerTask.this.set(SanitizerTask.this.unprepared);
                                    } else {
                                        SanitizerTask.this.unprepared.view.post(new Runnable(){

                                            @Override
                                            public void run() {
                                                SanitizerTask.this.unprepared.view.requestFocusNodeHref(MAIN_HANDLER.obtainMessage(1, (Object)SanitizerTask.this));
                                            }
                                        });
                                    }
                                } else {
                                    SanitizerTask.this.unprepared.view.postDelayed((Runnable)SanitizerTask.this, 100L);
                                }
                            } else {
                                SanitizerTask.this.setException(new RuntimeException("Fatal exception checking document state: " + eval));
                            }
                        }
                        catch (ExecutionException ee) {
                            SanitizerTask.this.setException(ee.getCause());
                        }
                        catch (InterruptedException ie) {
                            SanitizerTask.this.setException(ie.getCause());
                        }
                    }
                }, (Executor)MoreExecutors.sameThreadExecutor());
            } else {
                this.unprepared.view.postDelayed((Runnable)this, 100L);
            }
        }

        private boolean isWebViewSane() {
            boolean webHistoryReady;
            String url = this.unprepared.view.getUrl();
            WebHistoryItem current = this.unprepared.view.copyBackForwardList().getCurrentItem();
            boolean getUrlReady = url != null;
            boolean bl = webHistoryReady = current != null;
            if (getUrlReady && webHistoryReady) {
                String historyUrl = current.getUrl();
                boolean viewAndHistoryMatch = url.equals(historyUrl);
                boolean nonZeroContentHeight = this.unprepared.view.getContentHeight() != 0;
                boolean progressComplete = this.unprepared.view.getProgress() == 100;
                this.sanityMessage = String.format("viewAndHistoryUrlsMatch: %s, nonZeroContentHeight: %s, progressComplete: %s", viewAndHistoryMatch, nonZeroContentHeight, progressComplete);
                return viewAndHistoryMatch && progressComplete && nonZeroContentHeight;
            }
            this.sanityMessage = String.format("view.getUrl() != null: %s view.copyBackForwardList().getCurrentItem() != null: %s", getUrlReady, webHistoryReady);
            return false;
        }
    }
}

