/*
 * Decompiled with CFR 0.152.
 */
package android.support.test.espresso.web.assertion;

import android.support.test.espresso.NoMatchingViewException;
import android.support.test.espresso.ViewAssertion;
import android.support.test.espresso.web.model.Atom;
import android.view.View;
import android.webkit.WebView;
import com.google.common.base.Preconditions;

public abstract class WebAssertion<E> {
    private final Atom<E> atom;

    public WebAssertion(Atom<E> atom) {
        this.atom = (Atom)Preconditions.checkNotNull(atom);
    }

    public final Atom<E> getAtom() {
        return this.atom;
    }

    public final ViewAssertion toViewAssertion(final E result) {
        Preconditions.checkNotNull(result);
        return new ViewAssertion(){

            public void check(View v, NoMatchingViewException noView) {
                if (null == v) {
                    throw noView;
                }
                if (!(v instanceof WebView)) {
                    throw new RuntimeException(v + ": is not a webview!");
                }
                WebAssertion.this.checkResult((WebView)v, result);
            }
        };
    }

    protected abstract void checkResult(WebView var1, E var2);
}

