/*
 * Decompiled with CFR 0.152.
 */
package android.support.test.espresso.web.assertion;

import android.support.test.espresso.matcher.ViewMatchers;
import android.support.test.espresso.web.assertion.TagSoupDocumentParser;
import android.support.test.espresso.web.assertion.WebAssertion;
import android.support.test.espresso.web.model.Atom;
import android.support.test.espresso.web.model.Atoms;
import android.support.test.espresso.web.model.Evaluation;
import android.support.test.espresso.web.model.TransformingAtom;
import android.webkit.WebView;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.StringWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.StringDescription;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public final class WebViewAssertions {
    private static final ResultDescriber<Object> TO_STRING_DESCRIBER = new ResultDescriber<Object>(){

        @Override
        public String apply(Object input) {
            return input.toString();
        }
    };

    private WebViewAssertions() {
    }

    public static <E> WebAssertion<E> webMatches(Atom<E> atom, final Matcher<E> resultMatcher, final ResultDescriber<? super E> resultDescriber) {
        Preconditions.checkNotNull(resultMatcher);
        Preconditions.checkNotNull(resultDescriber);
        Preconditions.checkNotNull(atom);
        return new WebAssertion<E>(atom){

            @Override
            public void checkResult(WebView view, E result) {
                StringDescription description = new StringDescription();
                description.appendText("'");
                resultMatcher.describeTo((Description)description);
                description.appendText("' doesn't match: ");
                description.appendText(null == result ? "null" : resultDescriber.apply(result));
                ViewMatchers.assertThat((String)description.toString(), result, (Matcher)resultMatcher);
            }
        };
    }

    public static <E> WebAssertion<E> webMatches(Atom<E> atom, Matcher<E> resultMatcher) {
        return WebViewAssertions.webMatches(atom, resultMatcher, TO_STRING_DESCRIBER);
    }

    public static WebAssertion<Document> webContent(Matcher<Document> domMatcher) {
        Preconditions.checkNotNull(domMatcher);
        return WebViewAssertions.webMatches(Atoms.transform(Atoms.script("return document.documentElement.outerHTML;"), new TransformingAtom.Transformer<Evaluation, Document>(){

            @Override
            public Document apply(Evaluation eval) {
                if (eval.getValue() instanceof String) {
                    try {
                        return TagSoupDocumentParser.newInstance().parse((String)eval.getValue());
                    }
                    catch (SAXException se) {
                        throw new RuntimeException("Parse failed: " + eval.getValue(), se);
                    }
                    catch (IOException ioe) {
                        throw new RuntimeException("Parse failed: " + eval.getValue(), ioe);
                    }
                }
                throw new RuntimeException("Value should have been a string: " + eval);
            }
        }), domMatcher, new ResultDescriber<Document>(){

            @Override
            public String apply(Document document) {
                try {
                    DOMSource docSource = new DOMSource(document);
                    Transformer tf = TransformerFactory.newInstance().newTransformer();
                    StringWriter writer = new StringWriter();
                    StreamResult streamer = new StreamResult(writer);
                    tf.transform(docSource, streamer);
                    return writer.toString();
                }
                catch (TransformerException e) {
                    return "Could not transform!!!" + e;
                }
            }
        });
    }

    public static interface ResultDescriber<E> {
        public String apply(E var1);
    }
}

