/*
 * Decompiled with CFR 0.152.
 */
package android.support.test.espresso.web.bridge;

import android.os.Build;
import android.os.Handler;
import android.os.Message;
import android.support.test.InstrumentationRegistry;
import android.support.test.espresso.web.bridge.JavaScriptBoundBridge;
import android.support.test.espresso.web.bridge.JavaScriptBridgeInstallException;
import android.util.Log;
import android.webkit.WebChromeClient;
import android.webkit.WebView;
import com.google.common.base.Preconditions;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;

final class AndroidJavaScriptBridgeInstaller {
    private static final JavaScriptBoundBridge boundBridge = new JavaScriptBoundBridge();
    private static final String WEB_CORE_CLAZZ = "android.webkit.WebViewCore";
    private static final String WEB_CORE_HANDLER = "sWebCoreHandler";
    private static final String JAVASCRIPT_INTERFACES = "mJavascriptInterfaces";
    private static final String CALLBACK_PROXY_CLAZZ = "android.webkit.CallbackProxy";
    private static final String SET_WEB_CHROME_CLIENT_METHOD = "setWebChromeClient";
    private static final String CALLBACK_PROXY_FIELD = "mCallbackProxy";

    AndroidJavaScriptBridgeInstaller() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JavaScriptBoundBridge install() throws JavaScriptBridgeInstallException {
        try {
            Class<?> webCoreClazz = Class.forName(WEB_CORE_CLAZZ);
            Field webCoreHandlerField = webCoreClazz.getDeclaredField(WEB_CORE_HANDLER);
            Field javascriptInterfacesField = webCoreClazz.getDeclaredField(JAVASCRIPT_INTERFACES);
            Field callbackProxyField = null;
            Method setWebChromeClientMethod = null;
            if (Build.VERSION.SDK_INT < 13) {
                callbackProxyField = webCoreClazz.getDeclaredField(CALLBACK_PROXY_FIELD);
                Class<?> callbackProxyClazz = Class.forName(CALLBACK_PROXY_CLAZZ);
                setWebChromeClientMethod = callbackProxyClazz.getDeclaredMethod(SET_WEB_CHROME_CLIENT_METHOD, WebChromeClient.class);
                callbackProxyField.setAccessible(true);
                setWebChromeClientMethod.setAccessible(true);
            }
            webCoreHandlerField.setAccessible(true);
            javascriptInterfacesField.setAccessible(true);
            Handler webCoreHandler = null;
            Class<?> clazz = webCoreClazz;
            synchronized (clazz) {
                webCoreHandler = (Handler)webCoreHandlerField.get(null);
                if (null != webCoreHandler) {
                    Log.w((String)"JS_BRIDGE", (String)"Initializing late - some webviews may be unbridged.");
                }
            }
            if (null == webCoreHandler) {
                new WebView(InstrumentationRegistry.getTargetContext());
                while (null == webCoreHandler) {
                    clazz = webCoreClazz;
                    synchronized (clazz) {
                        webCoreHandler = (Handler)webCoreHandlerField.get(null);
                    }
                }
            }
            WebCoreHandlerSpy instrumentedHandler = new WebCoreHandlerSpy(webCoreHandler, javascriptInterfacesField, callbackProxyField, setWebChromeClientMethod);
            Class<?> clazz2 = webCoreClazz;
            synchronized (clazz2) {
                webCoreHandlerField.set(null, (Object)instrumentedHandler);
            }
        }
        catch (ClassNotFoundException cnfe) {
            throw new JavaScriptBridgeInstallException(cnfe);
        }
        catch (NoSuchFieldException nsfe) {
            throw new JavaScriptBridgeInstallException(nsfe);
        }
        catch (NoSuchMethodException nsme) {
            throw new JavaScriptBridgeInstallException(nsme);
        }
        catch (IllegalAccessException iae) {
            throw new JavaScriptBridgeInstallException(iae);
        }
        Log.i((String)"JS_BRIDGE", (String)"Initialized web view bridging for android WebView.");
        return boundBridge;
    }

    private static final class WebCoreHandlerSpy
    extends Handler {
        private final Handler realHandler;
        private final Field javascriptInterfacesField;
        private final Field callbackProxyField;
        private final Method setWebViewClientMethod;

        private WebCoreHandlerSpy(Handler realHandler, Field javascriptInterfacesField, Field callbackProxyField, Method setWebViewClientMethod) {
            super(realHandler.getLooper());
            this.realHandler = (Handler)Preconditions.checkNotNull((Object)realHandler);
            this.javascriptInterfacesField = (Field)Preconditions.checkNotNull((Object)javascriptInterfacesField);
            this.callbackProxyField = callbackProxyField;
            this.setWebViewClientMethod = setWebViewClientMethod;
        }

        public boolean sendMessageAtTime(Message message, long delayMillis) {
            if (message.what == 0) {
                try {
                    HashMap<String, JavaScriptBoundBridge> jsInterfaces = (HashMap<String, JavaScriptBoundBridge>)this.javascriptInterfacesField.get(message.obj);
                    if (null == jsInterfaces) {
                        jsInterfaces = new HashMap<String, JavaScriptBoundBridge>();
                        this.javascriptInterfacesField.set(message.obj, jsInterfaces);
                    }
                    jsInterfaces.put("__g_wd_jsb", boundBridge);
                    if (Build.VERSION.SDK_INT < 13) {
                        Object callbackProxy = this.callbackProxyField.get(message.obj);
                        this.setWebViewClientMethod.invoke(callbackProxy, new WebChromeClient());
                    }
                }
                catch (IllegalAccessException iae) {
                    Log.e((String)"JS_BRIDGE", (String)"Couldn't initialize js bridge in webview!", (Throwable)iae);
                }
                catch (InvocationTargetException ite) {
                    Log.e((String)"JS_BRIDGE", (String)"Couldn't initialize js bridge in webview!", (Throwable)ite);
                }
            }
            return super.sendMessageAtTime(message, delayMillis);
        }

        public void handleMessage(Message message) {
            this.realHandler.handleMessage(message);
        }
    }
}

