/*
 * Decompiled with CFR 0.152.
 */
package android.support.test.espresso.web.bridge;

import android.os.Build;
import android.os.Looper;
import android.support.test.espresso.web.bridge.AndroidJavaScriptBridgeInstaller;
import android.support.test.espresso.web.bridge.Conduit;
import android.support.test.espresso.web.bridge.JavaScriptBoundBridge;
import android.support.test.espresso.web.bridge.JavaScriptBridgeInstallException;
import android.util.Log;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.SettableFuture;
import java.util.concurrent.atomic.AtomicInteger;

public final class JavaScriptBridge {
    private static final AtomicInteger tokenGenerator = new AtomicInteger(0);
    static final String TAG = "JS_BRIDGE";
    static final String JS_BRIDGE_NAME = "__g_wd_jsb";
    private static volatile boolean initialized = false;
    private static JavaScriptBoundBridge boundBridge;

    public static Conduit makeConduit() {
        Preconditions.checkState((boolean)initialized, (Object)"Install bridge not called!");
        Preconditions.checkState((null != boundBridge ? 1 : 0) != 0, (Object)"Bridge not configured; chromium webviews do not need bridge");
        Conduit conduit = new Conduit.Builder().withBridgeName(JS_BRIDGE_NAME).withToken(String.valueOf(tokenGenerator.incrementAndGet())).withSuccessMethod("setResult").withErrorMethod("setError").withJsResult((SettableFuture<String>)SettableFuture.create()).build();
        boundBridge.addConduit(conduit);
        return conduit;
    }

    public static void installBridge() {
        Preconditions.checkState((Looper.getMainLooper() == Looper.myLooper() ? 1 : 0) != 0, (Object)"Must be on main thread!");
        if (initialized) {
            return;
        }
        try {
            if (Build.VERSION.SDK_INT < 19) {
                boundBridge = new AndroidJavaScriptBridgeInstaller().install();
            }
        }
        catch (JavaScriptBridgeInstallException e) {
            Log.e((String)TAG, (String)"Unable to bridge web views!", (Throwable)e);
        }
        initialized = true;
    }
}

