/*
 * Decompiled with CFR 0.152.
 */
package android.support.test.espresso.web.matcher;

import android.support.test.espresso.web.matcher.AmbiguousElementMatcherException;
import com.google.common.base.Preconditions;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class DomMatchers {
    private DomMatchers() {
    }

    public static Matcher<Document> containingTextInBody(String text) {
        Preconditions.checkNotNull((Object)text);
        return DomMatchers.withBody(DomMatchers.withTextContent((Matcher<String>)Matchers.containsString((String)text)));
    }

    public static Matcher<Document> withBody(final Matcher<Element> bodyMatcher) {
        Preconditions.checkNotNull(bodyMatcher);
        return new TypeSafeMatcher<Document>(){

            public void describeTo(Description description) {
                description.appendText("with body: ");
                bodyMatcher.describeTo(description);
            }

            public boolean matchesSafely(Document document) {
                NodeList nodeList = document.getElementsByTagName("body");
                if (nodeList.getLength() == 0) {
                    return false;
                }
                return bodyMatcher.matches((Object)nodeList.item(0));
            }
        };
    }

    public static Matcher<Document> hasElementWithId(final String id) {
        Preconditions.checkNotNull((Object)id);
        return new TypeSafeMatcher<Document>(){

            public void describeTo(Description description) {
                description.appendText("has element with id: " + id);
            }

            public boolean matchesSafely(Document document) {
                return document.getElementById(id) != null;
            }
        };
    }

    public static Matcher<Document> elementById(final String id, final Matcher<Element> elementMatcher) {
        Preconditions.checkNotNull((Object)id);
        return new TypeSafeMatcher<Document>(){

            public void describeTo(Description description) {
                description.appendText(String.format("element with id '%s' matches: ", id));
                elementMatcher.describeTo(description);
            }

            public boolean matchesSafely(Document document) {
                return elementMatcher.matches((Object)document.getElementById(id));
            }
        };
    }

    public static Matcher<Document> hasElementWithXpath(final String xpath) {
        Preconditions.checkNotNull((Object)xpath);
        return new TypeSafeMatcher<Document>(){

            public void describeTo(Description description) {
                description.appendText("has element with xpath: " + xpath);
            }

            public boolean matchesSafely(Document document) {
                NodeList nodeList = DomMatchers.extractNodeListForXPath(xpath, document);
                return nodeList != null && nodeList.getLength() != 0;
            }
        };
    }

    public static Matcher<Document> elementByXPath(final String xpath, final Matcher<Element> elementMatcher) {
        Preconditions.checkNotNull((Object)xpath);
        return new TypeSafeMatcher<Document>(){

            public void describeTo(Description description) {
                description.appendText(String.format("element with xpath '%s' matches: ", xpath));
                elementMatcher.describeTo(description);
            }

            public boolean matchesSafely(Document document) {
                NodeList nodeList = DomMatchers.extractNodeListForXPath(xpath, document);
                if (nodeList == null || nodeList.getLength() == 0) {
                    return false;
                }
                if (nodeList.getLength() > 1) {
                    throw new AmbiguousElementMatcherException(xpath);
                }
                if (nodeList.item(0).getNodeType() != 1) {
                    return false;
                }
                Element element = (Element)nodeList.item(0);
                return elementMatcher.matches((Object)element);
            }
        };
    }

    private static NodeList extractNodeListForXPath(String xpath, Document document) {
        try {
            XPath xPath = XPathFactory.newInstance().newXPath();
            XPathExpression expr = xPath.compile(xpath);
            return (NodeList)expr.evaluate(document, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            return null;
        }
    }

    public static Matcher<Element> withTextContent(String textContent) {
        return DomMatchers.withTextContent((Matcher<String>)Matchers.is((Object)textContent));
    }

    public static Matcher<Element> withTextContent(final Matcher<String> textContentMatcher) {
        Preconditions.checkNotNull(textContentMatcher);
        return new TypeSafeMatcher<Element>(){

            public void describeTo(Description description) {
                description.appendText("with text content: ");
                textContentMatcher.describeTo(description);
            }

            public boolean matchesSafely(Element element) {
                return textContentMatcher.matches((Object)element.getTextContent());
            }
        };
    }
}

