/*
 * Decompiled with CFR 0.152.
 */
package android.support.test.espresso.web.model;

import android.support.annotation.Nullable;
import android.support.test.espresso.web.model.JSONAble;
import android.support.test.espresso.web.model.ModelCodec;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONStringer;
import org.json.JSONTokener;

public final class Evaluation
implements JSONAble {
    private static final String STATUS_KEY = "status";
    private static final String MESSAGE_KEY = "message";
    private static final String VALUE_KEY = "value";
    private final int status;
    private final boolean hasMessage;
    private final String message;
    private final Object value;
    static final JSONAble.DeJSONFactory DEJSONIZER = new JSONAble.DeJSONFactory(){

        @Override
        public Object attemptDeJSONize(Map<String, Object> map) {
            Object maybeValue;
            Object maybeStatus;
            if (map.size() == 2 && (maybeStatus = map.get(Evaluation.STATUS_KEY)) instanceof Integer && null != (maybeValue = map.get(Evaluation.VALUE_KEY))) {
                Map mapValue;
                Builder builder = new Builder().setStatus((Integer)maybeStatus).setValue(maybeValue == JSONObject.NULL ? null : maybeValue);
                if (maybeValue instanceof Map && (mapValue = (Map)maybeValue).size() == 1) {
                    Object maybeMessage = mapValue.get(Evaluation.MESSAGE_KEY);
                    if (maybeMessage instanceof String) {
                        builder.setMessage((String)maybeMessage);
                    } else if (maybeMessage == JSONObject.NULL) {
                        builder.setMessage(null);
                    }
                }
                return builder.build();
            }
            return null;
        }
    };

    private Evaluation(Builder b) {
        this.status = b.status;
        this.value = b.value;
        this.hasMessage = b.hasMessage;
        this.message = b.message;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.status, this.value, this.hasMessage, this.message});
    }

    public boolean equals(Object o) {
        if (o instanceof Evaluation) {
            Evaluation other = (Evaluation)o;
            if (other.status == this.status && this.hasMessage == other.hasMessage) {
                if (this.hasMessage) {
                    return this.message.equals(other.message);
                }
                if (this.value == null) {
                    return other.value == null;
                }
                return this.value.equals(other.value);
            }
        }
        return false;
    }

    public int getStatus() {
        return this.status;
    }

    @Nullable
    public Object getValue() {
        return this.value;
    }

    public boolean hasMessage() {
        return this.hasMessage;
    }

    public String getMessage() {
        Preconditions.checkState((boolean)this.hasMessage);
        return this.message;
    }

    @Override
    public String toJSONString() {
        try {
            JSONStringer stringer = new JSONStringer().object().key(STATUS_KEY).value((long)this.status).key(VALUE_KEY);
            if (this.value instanceof String || this.value instanceof Number || this.value instanceof Boolean || this.value == null) {
                stringer.value(this.value);
            } else {
                String jsonValue = ModelCodec.encode(this.value);
                stringer.value(new JSONTokener(jsonValue).nextValue());
            }
            stringer.endObject();
            return stringer.toString();
        }
        catch (JSONException je) {
            throw new RuntimeException(je);
        }
    }

    public String toString() {
        return String.format("Evaluation: status: %d value: %s hasMessage: %s message: %s", this.status, this.value, this.hasMessage, this.message);
    }

    static class Builder {
        private Object value;
        private int status;
        private boolean hasMessage;
        private String message;

        Builder() {
        }

        public Builder setMessage(String message) {
            this.message = message;
            this.hasMessage = true;
            return this;
        }

        public Builder setValue(Object value) {
            this.value = value;
            return this;
        }

        public Builder setStatus(int status) {
            this.status = status;
            return this;
        }

        public Evaluation build() {
            return new Evaluation(this);
        }
    }
}

