/*
 * Decompiled with CFR 0.152.
 */
package android.support.test.espresso.web.sugar;

import android.os.Handler;
import android.os.Looper;
import android.support.annotation.Nullable;
import android.support.test.espresso.Espresso;
import android.support.test.espresso.UiController;
import android.support.test.espresso.ViewAction;
import android.support.test.espresso.matcher.ViewMatchers;
import android.support.test.espresso.web.action.AtomAction;
import android.support.test.espresso.web.action.EnableJavascriptAction;
import android.support.test.espresso.web.assertion.WebAssertion;
import android.support.test.espresso.web.bridge.JavaScriptBridge;
import android.support.test.espresso.web.model.Atom;
import android.support.test.espresso.web.model.ElementReference;
import android.support.test.espresso.web.model.WindowReference;
import android.support.test.internal.runner.tracker.UsageTrackerRegistry;
import android.view.View;
import com.google.common.base.Preconditions;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public final class Web {
    public static WebInteraction<Void> onWebView() {
        return Web.onWebView((Matcher<View>)ViewMatchers.isJavascriptEnabled());
    }

    public static WebInteraction<Void> onWebView(Matcher<View> viewMatcher) {
        return new WebInteraction<Void>(viewMatcher);
    }

    private static void installBridgeOnMainThread() {
        Handler mainHandler = new Handler(Looper.getMainLooper());
        mainHandler.post(new Runnable(){

            @Override
            public void run() {
                JavaScriptBridge.installBridge();
            }
        });
    }

    static {
        Web.installBridgeOnMainThread();
        UsageTrackerRegistry.getInstance().trackUsage("Espresso-Web");
    }

    public static class WebInteraction<R> {
        private final Matcher<View> viewMatcher;
        private final boolean brandNew;
        @Nullable
        private final R result;
        @Nullable
        private final WindowReference window;
        @Nullable
        private final ElementReference element;
        private final Timeout timeout;

        private WebInteraction(Matcher<View> viewMatcher) {
            this(viewMatcher, null, null, null, true, new Timeout(10L, TimeUnit.SECONDS, true));
        }

        private WebInteraction(Matcher<View> viewMatcher, R result, WindowReference window, ElementReference element, boolean brandNew, Timeout timeout) {
            this.viewMatcher = (Matcher)Preconditions.checkNotNull(viewMatcher);
            this.result = result;
            this.window = window;
            this.element = element;
            this.brandNew = brandNew;
            this.timeout = timeout;
        }

        public WebInteraction<R> reset() {
            return new WebInteraction<R>(this.viewMatcher, this.result, null, null, this.brandNew, this.timeout);
        }

        public WebInteraction<R> forceJavascriptEnabled() {
            Espresso.onView(this.viewMatcher).perform(new ViewAction[]{new EnableJavascriptAction()});
            return this;
        }

        public WebInteraction<R> withNoTimeout() {
            return new WebInteraction<R>(this.viewMatcher, this.result, this.window, this.element, this.brandNew, Timeout.NONE);
        }

        public WebInteraction<R> withTimeout(long amount, TimeUnit unit) {
            return new WebInteraction<R>(this.viewMatcher, this.result, this.window, this.element, this.brandNew, new Timeout(amount, unit, true));
        }

        public WebInteraction<R> inWindow(WindowReference window) {
            return new WebInteraction<R>(this.viewMatcher, this.result, window, this.element, this.brandNew, this.timeout);
        }

        public WebInteraction<R> inWindow(Atom<WindowReference> windowPicker) {
            return new WebInteraction<R>(this.viewMatcher, this.result, this.doEval(windowPicker, null, null), this.element, this.brandNew, this.timeout);
        }

        public WebInteraction<R> withElement(ElementReference element) {
            return new WebInteraction<R>(this.viewMatcher, this.result, this.window, element, this.brandNew, this.timeout);
        }

        public WebInteraction<R> withElement(Atom<ElementReference> elementPicker) {
            return new WebInteraction<R>(this.viewMatcher, this.result, this.window, this.doEval(elementPicker, this.window, null), this.brandNew, this.timeout);
        }

        public WebInteraction<R> withContextualElement(Atom<ElementReference> elementPicker) {
            return new WebInteraction<R>(this.viewMatcher, this.result, this.window, this.doEval(elementPicker, this.window, this.element), this.brandNew, this.timeout);
        }

        public <E> WebInteraction<E> perform(Atom<E> atom) {
            E newResult = this.doEval(atom, this.window, this.element);
            return new WebInteraction<E>(this.viewMatcher, newResult, this.window, this.element, false, this.timeout);
        }

        public <E> WebInteraction<E> check(WebAssertion<E> assertion) {
            E newResult = this.doEval(assertion.getAtom(), this.window, this.element);
            Espresso.onView(this.viewMatcher).check(assertion.toViewAssertion(newResult));
            return new WebInteraction<E>(this.viewMatcher, newResult, this.window, this.element, false, this.timeout);
        }

        private <E> E doEval(Atom<E> atom, WindowReference window, ElementReference elem) {
            Preconditions.checkNotNull(atom, (Object)"Need an atom!");
            AtomAction<E> atomAction = new AtomAction<E>(atom, window, elem);
            Espresso.onView(this.viewMatcher).perform(new ViewAction[]{atomAction});
            try {
                if (this.timeout == Timeout.NONE) {
                    return atomAction.get();
                }
                return atomAction.get(this.timeout.timeout, this.timeout.unit);
            }
            catch (ExecutionException ee) {
                Espresso.onView(this.viewMatcher).perform(new ViewAction[]{new ExceptionPropagator(ee.getCause())});
                return null;
            }
            catch (InterruptedException ie) {
                Espresso.onView(this.viewMatcher).perform(new ViewAction[]{new ExceptionPropagator(ie)});
                return null;
            }
            catch (TimeoutException te) {
                Espresso.onView(this.viewMatcher).perform(new ViewAction[]{new ExceptionPropagator(te)});
                return null;
            }
            catch (RuntimeException re) {
                Espresso.onView(this.viewMatcher).perform(new ViewAction[]{new ExceptionPropagator(re)});
                return null;
            }
        }

        public R get() {
            Preconditions.checkState((!this.brandNew ? 1 : 0) != 0, (Object)"Perform or Check never called on this WebInteraction!");
            return this.result;
        }

        private static class ExceptionPropagator
        implements ViewAction {
            private RuntimeException error;

            public ExceptionPropagator(RuntimeException error) {
                this.error = (RuntimeException)Preconditions.checkNotNull((Object)error);
            }

            public ExceptionPropagator(Throwable t) {
                this(new RuntimeException(t));
            }

            public String getDescription() {
                return "Propagate: " + this.error;
            }

            public void perform(UiController uiController, View view) {
                throw this.error;
            }

            public Matcher<View> getConstraints() {
                return Matchers.any(View.class);
            }
        }
    }

    private static class Timeout {
        private final long timeout;
        private final TimeUnit unit;
        static final Timeout NONE = new Timeout(-1L, TimeUnit.MILLISECONDS, false);

        private Timeout(long timeout, TimeUnit unit, boolean check) {
            this.timeout = timeout;
            this.unit = unit;
            if (check) {
                Preconditions.checkArgument((timeout > 0L ? 1 : 0) != 0);
                Preconditions.checkNotNull((Object)((Object)unit));
            }
        }
    }
}

