/*
 * Decompiled with CFR 0.152.
 */
package android.support.test.espresso.web.bridge;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;

public final class Conduit {
    private final String bridgeName;
    private final String errorMethod;
    private final String successMethod;
    private final String token;
    private final SettableFuture<String> jsResult;

    private Conduit(Builder builder) {
        this.bridgeName = (String)Preconditions.checkNotNull((Object)builder.bridgeName);
        this.errorMethod = (String)Preconditions.checkNotNull((Object)builder.errorMethod);
        this.successMethod = (String)Preconditions.checkNotNull((Object)builder.successMethod);
        this.token = (String)Preconditions.checkNotNull((Object)builder.token);
        this.jsResult = (SettableFuture)Preconditions.checkNotNull((Object)builder.jsResult);
    }

    public String wrapScriptInConduit(String script) {
        Preconditions.checkNotNull((Object)script);
        return this.wrapScriptInConduit(new StringBuilder(script)).toString();
    }

    public StringBuilder wrapScriptInConduit(StringBuilder script) {
        String preamble = "try{window." + this.bridgeName + "." + this.successMethod + "('" + this.token + "', ";
        script.insert(0, preamble).append(");").append("}catch(e){").append("window.").append(this.bridgeName).append(".").append(this.errorMethod).append("('").append(this.token).append("', 'error!');}");
        return script;
    }

    public ListenableFuture<String> getResult() {
        return this.jsResult;
    }

    SettableFuture<String> internalGetResult() {
        return this.jsResult;
    }

    String getToken() {
        return this.token;
    }

    static class Builder {
        private String bridgeName;
        private String errorMethod;
        private String successMethod;
        private String token;
        private SettableFuture<String> jsResult;

        Builder() {
        }

        public Builder withBridgeName(String bridgeName) {
            this.bridgeName = (String)Preconditions.checkNotNull((Object)bridgeName);
            return this;
        }

        public Builder withErrorMethod(String errorMethod) {
            this.errorMethod = (String)Preconditions.checkNotNull((Object)errorMethod);
            return this;
        }

        public Builder withSuccessMethod(String successMethod) {
            this.successMethod = (String)Preconditions.checkNotNull((Object)successMethod);
            return this;
        }

        public Builder withToken(String token) {
            this.token = (String)Preconditions.checkNotNull((Object)token);
            return this;
        }

        public Builder withJsResult(SettableFuture<String> jsResult) {
            this.jsResult = (SettableFuture)Preconditions.checkNotNull(jsResult);
            return this;
        }

        public Conduit build() {
            return new Conduit(this);
        }
    }
}

