/*
 * Decompiled with CFR 0.152.
 */
package android.support.test.espresso.web.model;

import android.support.test.espresso.web.model.Atom;
import android.support.test.espresso.web.model.Evaluation;
import android.support.test.espresso.web.model.SimpleAtom;
import android.support.test.espresso.web.model.TransformingAtom;
import com.google.common.base.Preconditions;
import java.util.List;

public final class Atoms {
    private Atoms() {
    }

    public static <I, O> Atom<O> transform(Atom<I> in, TransformingAtom.Transformer<I, O> transformer) {
        return new TransformingAtom<I, O>(in, transformer);
    }

    public static <O> Atom<O> script(String script, TransformingAtom.Transformer<Evaluation, O> transformer) {
        return Atoms.transform(Atoms.script(script), transformer);
    }

    public static <E> TransformingAtom.Transformer<Evaluation, E> castOrDie(final Class<E> clazz) {
        Preconditions.checkNotNull(clazz);
        return new TransformingAtom.Transformer<Evaluation, E>(){

            @Override
            public E apply(Evaluation in) {
                if (null == in.getValue()) {
                    throw new RuntimeException("Atom evaluation returned null!");
                }
                if (clazz.isInstance(in.getValue())) {
                    return clazz.cast(in.getValue());
                }
                throw new RuntimeException(String.format("%s: is not compatible with Evaluation: %s", clazz.getName(), in.getValue().getClass().getName()));
            }
        };
    }

    public static Atom<Evaluation> script(String script) {
        return new SimpleAtom(script);
    }

    public static Atom<String> getCurrentUrl() {
        return Atoms.script("return document.location.href;", Atoms.castOrDie(String.class));
    }

    public static Atom<String> getTitle() {
        return Atoms.script("return document.title;", Atoms.castOrDie(String.class));
    }

    public static Atom<Evaluation> scriptWithArgs(String script, final List<? extends Object> args) {
        Preconditions.checkNotNull(args);
        return new SimpleAtom(script){

            @Override
            public List<? extends Object> getNonContextualArguments() {
                return args;
            }
        };
    }
}

