/*
 * Decompiled with CFR 0.152.
 */
package android.support.test.espresso.web.model;

import android.support.annotation.Nullable;
import android.support.test.espresso.web.model.Atom;
import android.support.test.espresso.web.model.ElementReference;
import android.support.test.espresso.web.model.Evaluation;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SimpleAtom
implements Atom<Evaluation> {
    private final String script;
    private final ElementReferencePlacement elementPlacement;

    public SimpleAtom(String script) {
        this(script, ElementReferencePlacement.FIRST);
    }

    public SimpleAtom(String script, ElementReferencePlacement elementPlacement) {
        this.script = (String)Preconditions.checkNotNull((Object)script);
        this.elementPlacement = (ElementReferencePlacement)((Object)Preconditions.checkNotNull((Object)((Object)elementPlacement)));
    }

    @Override
    public final String getScript() {
        return this.script;
    }

    @Override
    public final Evaluation transform(Evaluation e) {
        if (e.getStatus() != 0) {
            return (Evaluation)Preconditions.checkNotNull((Object)this.handleBadEvaluation(e), (Object)("Evaluation bad and handler returned null! " + e));
        }
        return e;
    }

    @Override
    public final List<? extends Object> getArguments(@Nullable ElementReference elementRef) {
        List nonContextualArguments = (List)Preconditions.checkNotNull(this.getNonContextualArguments());
        if (null == elementRef) {
            this.handleNoElementReference();
        }
        if (nonContextualArguments.size() == 0 && null == elementRef) {
            return Collections.EMPTY_LIST;
        }
        if (null == elementRef) {
            return nonContextualArguments;
        }
        ArrayList<ElementReference> args = new ArrayList<ElementReference>(nonContextualArguments.size() + 1);
        if (this.elementPlacement == ElementReferencePlacement.FIRST) {
            args.add(elementRef);
            args.addAll(nonContextualArguments);
        } else {
            args.addAll(nonContextualArguments);
            args.add(elementRef);
        }
        return args;
    }

    protected void handleNoElementReference() {
    }

    protected List<? extends Object> getNonContextualArguments() {
        return Collections.EMPTY_LIST;
    }

    protected Evaluation handleBadEvaluation(Evaluation e) {
        throw new RuntimeException("Error in evaluation" + e);
    }

    public static enum ElementReferencePlacement {
        FIRST,
        LAST;

    }
}

