/*
 * Decompiled with CFR 0.152.
 */
package android.support.test.espresso.web.webdriver;

import android.support.test.espresso.web.model.Atom;
import android.support.test.espresso.web.model.Atoms;
import android.support.test.espresso.web.model.ElementReference;
import android.support.test.espresso.web.model.Evaluation;
import android.support.test.espresso.web.model.SimpleAtom;
import android.support.test.espresso.web.model.TransformingAtom;
import android.support.test.espresso.web.model.WindowReference;
import android.support.test.espresso.web.webdriver.Locator;
import android.support.test.espresso.web.webdriver.WebDriverAtomScripts;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class DriverAtoms {
    private DriverAtoms() {
    }

    public static Atom<Evaluation> webClick() {
        return new SimpleAtom(WebDriverAtomScripts.CLICK_ANDROID){

            @Override
            public void handleNoElementReference() {
                throw new RuntimeException("webClick: Need an element to click on!");
            }
        };
    }

    public static Atom<Evaluation> clearElement() {
        return new SimpleAtom(WebDriverAtomScripts.CLEAR_ANDROID){

            @Override
            public void handleNoElementReference() {
                throw new RuntimeException("clearElement: Need an element to clear!");
            }
        };
    }

    public static Atom<Evaluation> webKeys(final String text) {
        Preconditions.checkNotNull((Object)text);
        return new SimpleAtom(WebDriverAtomScripts.SEND_KEYS_ANDROID){

            @Override
            public void handleNoElementReference() {
                throw new RuntimeException("webKeys: Need an element to type on!");
            }

            public List<Object> getNonContextualArguments() {
                return Lists.newArrayList((Object[])new Object[]{text});
            }
        };
    }

    public static Atom<ElementReference> findElement(Locator locator, String value) {
        final Map<String, String> locatorJson = DriverAtoms.makeLocatorJSON(locator, value);
        SimpleAtom atom = new SimpleAtom(WebDriverAtomScripts.FIND_ELEMENT_ANDROID, SimpleAtom.ElementReferencePlacement.LAST){

            public List<Object> getNonContextualArguments() {
                return Lists.newArrayList((Object[])new Object[]{locatorJson});
            }
        };
        return new TransformingAtom<Evaluation, ElementReference>(atom, Atoms.castOrDie(ElementReference.class));
    }

    public static Atom<ElementReference> selectActiveElement() {
        SimpleAtom atom = new SimpleAtom(WebDriverAtomScripts.ACTIVE_ELEMENT_ANDROID);
        return new TransformingAtom<Evaluation, ElementReference>(atom, Atoms.castOrDie(ElementReference.class));
    }

    public static Atom<WindowReference> selectFrameByIndex(int index) {
        return DriverAtoms.internalFrameByIndex(index, null);
    }

    public static Atom<WindowReference> selectFrameByIndex(int index, WindowReference root) {
        Preconditions.checkNotNull((Object)root);
        return DriverAtoms.internalFrameByIndex(index, root);
    }

    private static Atom<WindowReference> internalFrameByIndex(final int index, final WindowReference optRoot) {
        SimpleAtom atom = new SimpleAtom(WebDriverAtomScripts.FRAME_BY_INDEX_ANDROID){

            public List<Object> getNonContextualArguments() {
                ArrayList args = Lists.newArrayList((Object[])new Object[]{index});
                if (null != optRoot) {
                    args.add(optRoot);
                }
                return args;
            }
        };
        return new TransformingAtom<Evaluation, WindowReference>(atom, Atoms.castOrDie(WindowReference.class));
    }

    public static Atom<WindowReference> selectFrameByIdOrName(String idOrName, WindowReference root) {
        Preconditions.checkNotNull((Object)idOrName);
        Preconditions.checkNotNull((Object)root);
        return DriverAtoms.internalFrameByIdOrName(idOrName, root);
    }

    public static Atom<WindowReference> selectFrameByIdOrName(String idOrName) {
        Preconditions.checkNotNull((Object)idOrName);
        return DriverAtoms.internalFrameByIdOrName(idOrName, null);
    }

    private static Atom<WindowReference> internalFrameByIdOrName(final String idOrName, final WindowReference optRoot) {
        SimpleAtom atom = new SimpleAtom(WebDriverAtomScripts.FRAME_BY_ID_OR_NAME_ANDROID){

            public List<Object> getNonContextualArguments() {
                ArrayList args = Lists.newArrayList((Object[])new Object[]{idOrName});
                if (null != optRoot) {
                    args.add(optRoot);
                }
                return args;
            }
        };
        return new TransformingAtom<Evaluation, WindowReference>(atom, Atoms.castOrDie(WindowReference.class));
    }

    public static Atom<String> getText() {
        return new TransformingAtom<Evaluation, String>(new SimpleAtom(WebDriverAtomScripts.GET_VISIBLE_TEXT_ANDROID), Atoms.castOrDie(String.class));
    }

    public static Atom<List<ElementReference>> findMultipleElements(final Locator locator, final String value) {
        final Map<String, String> locatorJson = DriverAtoms.makeLocatorJSON(locator, value);
        SimpleAtom atom = new SimpleAtom(WebDriverAtomScripts.FIND_ELEMENTS_ANDROID, SimpleAtom.ElementReferencePlacement.LAST){

            public List<Object> getNonContextualArguments() {
                return Lists.newArrayList((Object[])new Object[]{locatorJson});
            }
        };
        return new TransformingAtom<Evaluation, List<ElementReference>>(atom, new TransformingAtom.Transformer<Evaluation, List<ElementReference>>(){

            @Override
            public List<ElementReference> apply(Evaluation e) {
                Object rawValues = e.getValue();
                if (null == rawValues) {
                    return Lists.newArrayList();
                }
                if (rawValues instanceof Iterable) {
                    ArrayList references = Lists.newArrayList();
                    for (Object rawValue : (Iterable)rawValues) {
                        if (rawValue instanceof ElementReference) {
                            references.add((ElementReference)rawValue);
                            continue;
                        }
                        throw new RuntimeException(String.format("Unexpected non-elementReference in findMultipleElements(%s, %s): (%s) all: %s ", locator.name(), value, rawValue, e));
                    }
                    return references;
                }
                throw new RuntimeException(String.format("Unexpected non-iterableType in findMultipleElements(%s, %s): return evaluation: %s ", locator.name(), value, e));
            }
        });
    }

    private static Map<String, String> makeLocatorJSON(Locator locator, String value) {
        Preconditions.checkNotNull((Object)((Object)locator));
        Preconditions.checkNotNull((Object)value);
        HashMap map = Maps.newHashMap();
        map.put(locator.getType(), value);
        return map;
    }
}

