/*
 * Decompiled with CFR 0.152.
 */
package android.support.test.uiautomator;

import android.support.test.uiautomator.BySelector;
import android.support.test.uiautomator.UiDevice;
import android.util.Log;
import android.view.accessibility.AccessibilityNodeInfo;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;

class ByMatcher {
    private static final String TAG = ByMatcher.class.getSimpleName();
    private UiDevice mDevice;
    private BySelector mSelector;
    private boolean mShortCircuit;

    private ByMatcher(UiDevice device, BySelector selector, boolean shortCircuit) {
        this.mDevice = device;
        this.mSelector = selector;
        this.mShortCircuit = shortCircuit;
    }

    static AccessibilityNodeInfo findMatch(UiDevice device, AccessibilityNodeInfo root, BySelector selector) {
        ByMatcher matcher = new ByMatcher(device, selector, true);
        List<AccessibilityNodeInfo> matches = matcher.findMatches(root);
        return matches.isEmpty() ? null : matches.get(0);
    }

    static List<AccessibilityNodeInfo> findMatches(UiDevice device, AccessibilityNodeInfo root, BySelector selector) {
        return new ByMatcher(device, selector, false).findMatches(root);
    }

    private List<AccessibilityNodeInfo> findMatches(AccessibilityNodeInfo root) {
        List<AccessibilityNodeInfo> ret = this.findMatches(root, 0, 0, new SinglyLinkedList<PartialMatch>());
        if (ret.isEmpty()) {
            this.mDevice.runWatchers();
            ret = this.findMatches(root, 0, 0, new SinglyLinkedList<PartialMatch>());
        }
        return ret;
    }

    private List<AccessibilityNodeInfo> findMatches(AccessibilityNodeInfo node, int index, int depth, SinglyLinkedList<PartialMatch> partialMatches) {
        ArrayList<AccessibilityNodeInfo> ret = new ArrayList<AccessibilityNodeInfo>();
        if (!node.isVisibleToUser()) {
            return ret;
        }
        for (PartialMatch partialMatch : partialMatches) {
            partialMatches = partialMatch.update(node, index, depth, partialMatches);
        }
        PartialMatch currentMatch = PartialMatch.accept(node, this.mSelector, index, depth);
        if (currentMatch != null) {
            partialMatches = SinglyLinkedList.prepend(currentMatch, partialMatches);
        }
        int numChildren = node.getChildCount();
        boolean hasNullChild = false;
        for (int i = 0; i < numChildren; ++i) {
            AccessibilityNodeInfo child = node.getChild(i);
            if (child == null) {
                if (!hasNullChild) {
                    Log.w((String)TAG, (String)String.format("Node returned null child: %s", node.toString()));
                }
                hasNullChild = true;
                Log.w((String)TAG, (String)String.format("Skipping null child (%s of %s)", i, numChildren));
                continue;
            }
            ret.addAll(this.findMatches(child, i, depth + 1, partialMatches));
            child.recycle();
            if (ret.isEmpty() || !this.mShortCircuit) continue;
            return ret;
        }
        if (currentMatch != null && currentMatch.finalizeMatch()) {
            ret.add(AccessibilityNodeInfo.obtain((AccessibilityNodeInfo)node));
        }
        return ret;
    }

    private static boolean checkCriteria(Pattern criteria, CharSequence value) {
        if (criteria == null) {
            return true;
        }
        return criteria.matcher(value != null ? value : "").matches();
    }

    private static boolean checkCriteria(Boolean criteria, boolean value) {
        if (criteria == null) {
            return true;
        }
        return criteria.equals(value);
    }

    private static class SinglyLinkedList<T>
    implements Iterable<T> {
        private final Node<T> mHead;

        public SinglyLinkedList() {
            this(null);
        }

        private SinglyLinkedList(Node<T> head) {
            this.mHead = head;
        }

        public static <T> SinglyLinkedList<T> prepend(T data, SinglyLinkedList<T> rest) {
            return new SinglyLinkedList<T>(new Node<T>(data, rest.mHead));
        }

        @Override
        public Iterator<T> iterator() {
            return new Iterator<T>(){
                private Node<T> mNext;
                {
                    this.mNext = SinglyLinkedList.this.mHead;
                }

                @Override
                public boolean hasNext() {
                    return this.mNext != null;
                }

                @Override
                public T next() {
                    Object ret = this.mNext.data;
                    this.mNext = this.mNext.next;
                    return ret;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        private static class Node<T> {
            public final T data;
            public final Node<T> next;

            public Node(T d, Node<T> n) {
                this.data = d;
                this.next = n;
            }
        }
    }

    private static class PartialMatch {
        private final int matchDepth;
        private final BySelector matchSelector;
        private final List<PartialMatch> partialMatches = new ArrayList<PartialMatch>();

        private PartialMatch(BySelector selector, int depth) {
            this.matchSelector = selector;
            this.matchDepth = depth;
        }

        public static PartialMatch accept(AccessibilityNodeInfo node, BySelector selector, int index, int depth) {
            return PartialMatch.accept(node, selector, index, depth, depth);
        }

        public static PartialMatch accept(AccessibilityNodeInfo node, BySelector selector, int index, int absoluteDepth, int relativeDepth) {
            if (selector.mMinDepth != null && relativeDepth < selector.mMinDepth || selector.mMaxDepth != null && relativeDepth > selector.mMaxDepth) {
                return null;
            }
            PartialMatch ret = null;
            if (ByMatcher.checkCriteria(selector.mClazz, node.getClassName()) && ByMatcher.checkCriteria(selector.mDesc, node.getContentDescription()) && ByMatcher.checkCriteria(selector.mPkg, node.getPackageName()) && ByMatcher.checkCriteria(selector.mRes, node.getViewIdResourceName()) && ByMatcher.checkCriteria(selector.mText, node.getText()) && ByMatcher.checkCriteria(selector.mChecked, node.isChecked()) && ByMatcher.checkCriteria(selector.mCheckable, node.isCheckable()) && ByMatcher.checkCriteria(selector.mClickable, node.isClickable()) && ByMatcher.checkCriteria(selector.mEnabled, node.isEnabled()) && ByMatcher.checkCriteria(selector.mFocused, node.isFocused()) && ByMatcher.checkCriteria(selector.mFocusable, node.isFocusable()) && ByMatcher.checkCriteria(selector.mLongClickable, node.isLongClickable()) && ByMatcher.checkCriteria(selector.mScrollable, node.isScrollable()) && ByMatcher.checkCriteria(selector.mSelected, node.isSelected())) {
                ret = new PartialMatch(selector, absoluteDepth);
            }
            return ret;
        }

        public SinglyLinkedList<PartialMatch> update(AccessibilityNodeInfo node, int index, int depth, SinglyLinkedList<PartialMatch> rest) {
            for (BySelector childSelector : this.matchSelector.mChildSelectors) {
                PartialMatch m = PartialMatch.accept(node, childSelector, index, depth, depth - this.matchDepth);
                if (m == null) continue;
                this.partialMatches.add(m);
                rest = SinglyLinkedList.prepend(m, rest);
            }
            return rest;
        }

        public boolean finalizeMatch() {
            HashSet<BySelector> matches = new HashSet<BySelector>();
            for (PartialMatch p : this.partialMatches) {
                if (!p.finalizeMatch()) continue;
                matches.add(p.matchSelector);
            }
            return matches.containsAll(this.matchSelector.mChildSelectors);
        }
    }
}

