/*
 * Decompiled with CFR 0.152.
 */
package android.support.test.uiautomator;

import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;

public class BySelector {
    Pattern mClazz;
    Pattern mDesc;
    Pattern mPkg;
    Pattern mRes;
    Pattern mText;
    Boolean mChecked;
    Boolean mCheckable;
    Boolean mClickable;
    Boolean mEnabled;
    Boolean mFocused;
    Boolean mFocusable;
    Boolean mLongClickable;
    Boolean mScrollable;
    Boolean mSelected;
    Integer mMinDepth;
    Integer mMaxDepth;
    List<BySelector> mChildSelectors = new LinkedList<BySelector>();

    BySelector() {
    }

    BySelector(BySelector original) {
        this.mClazz = original.mClazz;
        this.mDesc = original.mDesc;
        this.mPkg = original.mPkg;
        this.mRes = original.mRes;
        this.mText = original.mText;
        this.mChecked = original.mChecked;
        this.mCheckable = original.mCheckable;
        this.mClickable = original.mClickable;
        this.mEnabled = original.mEnabled;
        this.mFocused = original.mFocused;
        this.mFocusable = original.mFocusable;
        this.mLongClickable = original.mLongClickable;
        this.mScrollable = original.mScrollable;
        this.mSelected = original.mSelected;
        for (BySelector childSelector : original.mChildSelectors) {
            this.mChildSelectors.add(new BySelector(childSelector));
        }
    }

    public BySelector clazz(String className) {
        BySelector.checkNotNull(className, "className cannot be null");
        if (className.charAt(0) == '.') {
            return this.clazz("android.widget", className.substring(1));
        }
        return this.clazz(Pattern.compile(Pattern.quote(className)));
    }

    public BySelector clazz(String packageName, String className) {
        BySelector.checkNotNull(packageName, "packageName cannot be null");
        BySelector.checkNotNull(className, "className cannot be null");
        return this.clazz(Pattern.compile(Pattern.quote(String.format("%s.%s", packageName, className))));
    }

    public BySelector clazz(Class clazz) {
        BySelector.checkNotNull(clazz, "clazz cannot be null");
        return this.clazz(Pattern.compile(Pattern.quote(clazz.getName())));
    }

    public BySelector clazz(Pattern className) {
        BySelector.checkNotNull(className, "className cannot be null");
        if (this.mClazz != null) {
            throw new IllegalStateException("Class selector is already defined");
        }
        this.mClazz = className;
        return this;
    }

    public BySelector desc(String contentDescription) {
        BySelector.checkNotNull(contentDescription, "contentDescription cannot be null");
        return this.desc(Pattern.compile(Pattern.quote(contentDescription)));
    }

    public BySelector descContains(String substring) {
        BySelector.checkNotNull(substring, "substring cannot be null");
        return this.desc(Pattern.compile(String.format("^.*%s.*$", Pattern.quote(substring))));
    }

    public BySelector descStartsWith(String substring) {
        BySelector.checkNotNull(substring, "substring cannot be null");
        return this.desc(Pattern.compile(String.format("^%s.*$", Pattern.quote(substring))));
    }

    public BySelector descEndsWith(String substring) {
        BySelector.checkNotNull(substring, "substring cannot be null");
        return this.desc(Pattern.compile(String.format("^.*%s$", Pattern.quote(substring))));
    }

    public BySelector desc(Pattern contentDescription) {
        BySelector.checkNotNull(contentDescription, "contentDescription cannot be null");
        if (this.mDesc != null) {
            throw new IllegalStateException("Description selector is already defined");
        }
        this.mDesc = contentDescription;
        return this;
    }

    public BySelector pkg(String applicationPackage) {
        BySelector.checkNotNull(applicationPackage, "applicationPackage cannot be null");
        return this.pkg(Pattern.compile(Pattern.quote(applicationPackage)));
    }

    public BySelector pkg(Pattern applicationPackage) {
        BySelector.checkNotNull(applicationPackage, "applicationPackage cannot be null");
        if (this.mPkg != null) {
            throw new IllegalStateException("Package selector is already defined");
        }
        this.mPkg = applicationPackage;
        return this;
    }

    public BySelector res(String resourceName) {
        BySelector.checkNotNull(resourceName, "resourceName cannot be null");
        return this.res(Pattern.compile(Pattern.quote(resourceName)));
    }

    public BySelector res(String resourcePackage, String resourceId) {
        BySelector.checkNotNull(resourcePackage, "resourcePackage cannot be null");
        BySelector.checkNotNull(resourceId, "resourceId cannot be null");
        return this.res(Pattern.compile(Pattern.quote(String.format("%s:id/%s", resourcePackage, resourceId))));
    }

    public BySelector res(Pattern resourceName) {
        BySelector.checkNotNull(resourceName, "resourceName cannot be null");
        if (this.mRes != null) {
            throw new IllegalStateException("Resource name selector is already defined");
        }
        this.mRes = resourceName;
        return this;
    }

    public BySelector text(String textValue) {
        BySelector.checkNotNull(textValue, "textValue cannot be null");
        return this.text(Pattern.compile(Pattern.quote(textValue)));
    }

    public BySelector textContains(String substring) {
        BySelector.checkNotNull(substring, "substring cannot be null");
        return this.text(Pattern.compile(String.format("^.*%s.*$", Pattern.quote(substring))));
    }

    public BySelector textStartsWith(String substring) {
        BySelector.checkNotNull(substring, "substring cannot be null");
        return this.text(Pattern.compile(String.format("^%s.*$", Pattern.quote(substring))));
    }

    public BySelector textEndsWith(String substring) {
        BySelector.checkNotNull(substring, "substring cannot be null");
        return this.text(Pattern.compile(String.format("^.*%s$", Pattern.quote(substring))));
    }

    public BySelector text(Pattern textValue) {
        BySelector.checkNotNull(textValue, "textValue cannot be null");
        if (this.mText != null) {
            throw new IllegalStateException("Text selector is already defined");
        }
        this.mText = textValue;
        return this;
    }

    public BySelector checkable(boolean isCheckable) {
        if (this.mCheckable != null) {
            throw new IllegalStateException("Checkable selector is already defined");
        }
        this.mCheckable = isCheckable;
        return this;
    }

    public BySelector checked(boolean isChecked) {
        if (this.mChecked != null) {
            throw new IllegalStateException("Checked selector is already defined");
        }
        this.mChecked = isChecked;
        return this;
    }

    public BySelector clickable(boolean isClickable) {
        if (this.mClickable != null) {
            throw new IllegalStateException("Clickable selector is already defined");
        }
        this.mClickable = isClickable;
        return this;
    }

    public BySelector enabled(boolean isEnabled) {
        if (this.mEnabled != null) {
            throw new IllegalStateException("Enabled selector is already defined");
        }
        this.mEnabled = isEnabled;
        return this;
    }

    public BySelector focusable(boolean isFocusable) {
        if (this.mFocusable != null) {
            throw new IllegalStateException("Focusable selector is already defined");
        }
        this.mFocusable = isFocusable;
        return this;
    }

    public BySelector focused(boolean isFocused) {
        if (this.mFocused != null) {
            throw new IllegalStateException("Focused selector is already defined");
        }
        this.mFocused = isFocused;
        return this;
    }

    public BySelector longClickable(boolean isLongClickable) {
        if (this.mLongClickable != null) {
            throw new IllegalStateException("Long Clickable selector is already defined");
        }
        this.mLongClickable = isLongClickable;
        return this;
    }

    public BySelector scrollable(boolean isScrollable) {
        if (this.mScrollable != null) {
            throw new IllegalStateException("Scrollable selector is already defined");
        }
        this.mScrollable = isScrollable;
        return this;
    }

    public BySelector selected(boolean isSelected) {
        if (this.mSelected != null) {
            throw new IllegalStateException("Selected selector is already defined");
        }
        this.mSelected = isSelected;
        return this;
    }

    public BySelector depth(int exactDepth) {
        return this.depth(exactDepth, exactDepth);
    }

    public BySelector depth(int min, int max) {
        if (min < 0) {
            throw new IllegalArgumentException("min cannot be negative");
        }
        if (max < 0) {
            throw new IllegalArgumentException("max cannot be negative");
        }
        if (this.mMinDepth != null) {
            throw new IllegalStateException("Minimum Depth selector is already defined");
        }
        if (this.mMaxDepth != null) {
            throw new IllegalStateException("Maximum Depth selector is already defined");
        }
        this.mMinDepth = min;
        this.mMaxDepth = max;
        return this;
    }

    public BySelector minDepth(int min) {
        if (min < 0) {
            throw new IllegalArgumentException("min cannot be negative");
        }
        if (this.mMinDepth != null) {
            throw new IllegalStateException("Depth selector is already defined");
        }
        this.mMinDepth = min;
        return this;
    }

    public BySelector maxDepth(int max) {
        if (max < 0) {
            throw new IllegalArgumentException("max cannot be negative");
        }
        if (this.mMaxDepth != null) {
            throw new IllegalStateException("Depth selector is already defined");
        }
        this.mMaxDepth = max;
        return this;
    }

    public BySelector hasChild(BySelector childSelector) {
        BySelector.checkNotNull(childSelector, "childSelector cannot be null");
        return this.hasDescendant(childSelector, 1);
    }

    public BySelector hasDescendant(BySelector descendantSelector) {
        BySelector.checkNotNull(descendantSelector, "descendantSelector cannot be null");
        this.mChildSelectors.add(descendantSelector);
        return this;
    }

    public BySelector hasDescendant(BySelector descendantSelector, int maxDepth) {
        BySelector.checkNotNull(descendantSelector, "descendantSelector cannot be null");
        descendantSelector.mMaxDepth = maxDepth;
        this.mChildSelectors.add(descendantSelector);
        return this;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("BySelector [");
        if (this.mClazz != null) {
            builder.append("CLASS='").append(this.mClazz).append("', ");
        }
        if (this.mDesc != null) {
            builder.append("DESC='").append(this.mDesc).append("', ");
        }
        if (this.mPkg != null) {
            builder.append("PKG='").append(this.mPkg).append("', ");
        }
        if (this.mRes != null) {
            builder.append("RES='").append(this.mRes).append("', ");
        }
        if (this.mText != null) {
            builder.append("TEXT='").append(this.mText).append("', ");
        }
        if (this.mChecked != null) {
            builder.append("CHECKED='").append(this.mChecked).append("', ");
        }
        if (this.mCheckable != null) {
            builder.append("CHECKABLE='").append(this.mCheckable).append("', ");
        }
        if (this.mClickable != null) {
            builder.append("CLICKABLE='").append(this.mClickable).append("', ");
        }
        if (this.mEnabled != null) {
            builder.append("ENABLED='").append(this.mEnabled).append("', ");
        }
        if (this.mFocused != null) {
            builder.append("FOCUSED='").append(this.mFocused).append("', ");
        }
        if (this.mFocusable != null) {
            builder.append("FOCUSABLE='").append(this.mFocusable).append("', ");
        }
        if (this.mLongClickable != null) {
            builder.append("LONGCLICKABLE='").append(this.mLongClickable).append("', ");
        }
        if (this.mScrollable != null) {
            builder.append("SCROLLABLE='").append(this.mScrollable).append("', ");
        }
        if (this.mSelected != null) {
            builder.append("SELECTED='").append(this.mSelected).append("', ");
        }
        for (BySelector childSelector : this.mChildSelectors) {
            builder.append("CHILD='").append(childSelector.toString().substring(11)).append("', ");
        }
        builder.setLength(builder.length() - 2);
        builder.append("]");
        return builder.toString();
    }

    private static <T> T checkNotNull(T value, String message) {
        if (value == null) {
            throw new NullPointerException(message);
        }
        return value;
    }
}

