/*
 * Decompiled with CFR 0.152.
 */
package android.support.test.uiautomator;

import android.graphics.Point;
import android.os.SystemClock;
import android.support.test.uiautomator.EventCondition;
import android.support.test.uiautomator.PointerGesture;
import android.support.test.uiautomator.UiDevice;
import android.view.InputEvent;
import android.view.MotionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.PriorityQueue;

class GestureController {
    private static final long MOTION_EVENT_INJECTION_DELAY_MILLIS = 5L;
    private static GestureController sInstance;
    private UiDevice mDevice;
    private static final Comparator<PointerGesture> START_TIME_COMPARATOR;
    private static final Comparator<PointerGesture> END_TIME_COMPARATOR;

    private GestureController(UiDevice device) {
        this.mDevice = device;
    }

    public static GestureController getInstance(UiDevice device) {
        if (sInstance == null) {
            sInstance = new GestureController(device);
        }
        return sInstance;
    }

    public <R> R performGestureAndWait(EventCondition<R> condition, long timeout, PointerGesture ... gestures) {
        return this.mDevice.performActionAndWait(new GestureRunnable(gestures), condition, timeout);
    }

    public void performGesture(PointerGesture ... gestures) {
        int count = 0;
        HashMap<PointerGesture, Pointer> pointers = new HashMap<PointerGesture, Pointer>();
        for (PointerGesture g : gestures) {
            pointers.put(g, new Pointer(count++, g.start()));
        }
        ArrayList<MotionEvent.PointerProperties> properties = new ArrayList<MotionEvent.PointerProperties>();
        ArrayList<MotionEvent.PointerCoords> coordinates = new ArrayList<MotionEvent.PointerCoords>();
        PriorityQueue<PointerGesture> active = new PriorityQueue<PointerGesture>(gestures.length, END_TIME_COMPARATOR);
        PriorityQueue<PointerGesture> pending = new PriorityQueue<PointerGesture>(gestures.length, START_TIME_COMPARATOR);
        pending.addAll(Arrays.asList(gestures));
        long startTime = SystemClock.uptimeMillis();
        long elapsedTime = 0L;
        while (!pending.isEmpty() || !active.isEmpty()) {
            MotionEvent event;
            Pointer pointer;
            PointerGesture gesture;
            while (!pending.isEmpty() && elapsedTime > pending.peek().delay()) {
                gesture = (PointerGesture)pending.remove();
                pointer = (Pointer)pointers.get(gesture);
                properties.add(pointer.prop);
                coordinates.add(pointer.coords);
                int action = 0;
                if (!active.isEmpty()) {
                    action = 5 + (properties.size() - 1 << 8);
                }
                event = GestureController.getMotionEvent(startTime, startTime + elapsedTime, action, properties, coordinates);
                this.mDevice.getAutomatorBridge().injectInputEvent((InputEvent)event, true);
                active.add(gesture);
            }
            while (!active.isEmpty() && elapsedTime > active.peek().delay() + active.peek().duration()) {
                gesture = (PointerGesture)active.remove();
                pointer = (Pointer)pointers.get(gesture);
                pointer.updatePosition(gesture.end());
                for (PointerGesture current : active) {
                    ((Pointer)pointers.get(current)).updatePosition(current.pointAt(elapsedTime));
                }
                int action = 1;
                int index = properties.indexOf(pointer.prop);
                if (!active.isEmpty()) {
                    action = 6 + (index << 8);
                }
                event = GestureController.getMotionEvent(startTime, startTime + elapsedTime, action, properties, coordinates);
                this.mDevice.getAutomatorBridge().injectInputEvent((InputEvent)event, true);
                properties.remove(index);
                coordinates.remove(index);
            }
            for (PointerGesture gesture2 : active) {
                Pointer pointer2 = (Pointer)pointers.get(gesture2);
                pointer2.updatePosition(gesture2.pointAt(elapsedTime - gesture2.delay()));
            }
            if (!active.isEmpty()) {
                event = GestureController.getMotionEvent(startTime, startTime + elapsedTime, 2, properties, coordinates);
                this.mDevice.getAutomatorBridge().injectInputEvent((InputEvent)event, true);
            }
            elapsedTime = SystemClock.uptimeMillis() - startTime;
        }
    }

    private static MotionEvent getMotionEvent(long downTime, long eventTime, int action, List<MotionEvent.PointerProperties> properties, List<MotionEvent.PointerCoords> coordinates) {
        MotionEvent.PointerProperties[] props = properties.toArray(new MotionEvent.PointerProperties[properties.size()]);
        MotionEvent.PointerCoords[] coords = coordinates.toArray(new MotionEvent.PointerCoords[coordinates.size()]);
        return MotionEvent.obtain((long)downTime, (long)eventTime, (int)action, (int)props.length, (MotionEvent.PointerProperties[])props, (MotionEvent.PointerCoords[])coords, (int)0, (int)0, (float)1.0f, (float)1.0f, (int)0, (int)0, (int)4098, (int)0);
    }

    static {
        START_TIME_COMPARATOR = new Comparator<PointerGesture>(){

            @Override
            public int compare(PointerGesture o1, PointerGesture o2) {
                return (int)(o1.delay() - o2.delay());
            }
        };
        END_TIME_COMPARATOR = new Comparator<PointerGesture>(){

            @Override
            public int compare(PointerGesture o1, PointerGesture o2) {
                return (int)(o1.delay() + o2.duration() - (o2.delay() + o2.duration()));
            }
        };
    }

    private class GestureRunnable
    implements Runnable {
        private PointerGesture[] mGestures;

        public GestureRunnable(PointerGesture[] gestures) {
            this.mGestures = gestures;
        }

        @Override
        public void run() {
            GestureController.this.performGesture(this.mGestures);
        }
    }

    private static class Pointer {
        MotionEvent.PointerProperties prop = new MotionEvent.PointerProperties();
        MotionEvent.PointerCoords coords;

        public Pointer(int id, Point point) {
            this.prop.id = id;
            this.prop.toolType = 1;
            this.coords = new MotionEvent.PointerCoords();
            this.coords.pressure = 1.0f;
            this.coords.size = 1.0f;
            this.coords.x = point.x;
            this.coords.y = point.y;
        }

        public void updatePosition(Point point) {
            this.coords.x = point.x;
            this.coords.y = point.y;
        }
    }
}

