/*
 * Decompiled with CFR 0.152.
 */
package android.support.test.uiautomator;

import android.graphics.Point;
import java.util.ArrayDeque;
import java.util.Deque;

class PointerGesture {
    private Deque<PointerAction> mActions = new ArrayDeque<PointerAction>();
    private long mDelay;
    private long mDuration;

    public PointerGesture(Point startPoint) {
        this(startPoint, 0L);
    }

    public PointerGesture(Point startPoint, long initialDelay) {
        if (initialDelay < 0L) {
            throw new IllegalArgumentException("initialDelay cannot be negative");
        }
        this.mActions.addFirst(new PointerPauseAction(startPoint, 0L));
        this.mDelay = initialDelay;
    }

    public PointerGesture pause(long time) {
        if (time < 0L) {
            throw new IllegalArgumentException("time cannot be negative");
        }
        this.mActions.addLast(new PointerPauseAction(this.mActions.peekLast().end, time));
        this.mDuration += this.mActions.peekLast().duration;
        return this;
    }

    public PointerGesture move(Point dest, int speed) {
        this.mActions.addLast(new PointerLinearMoveAction(this.mActions.peekLast().end, dest, speed));
        this.mDuration += this.mActions.peekLast().duration;
        return this;
    }

    public Point start() {
        return this.mActions.peekFirst().start;
    }

    public Point end() {
        return this.mActions.peekLast().end;
    }

    public long duration() {
        return this.mDuration;
    }

    public long delay() {
        return this.mDelay;
    }

    public Point pointAt(long time) {
        if (time < 0L) {
            throw new IllegalArgumentException("Time cannot be negative");
        }
        time -= this.mDelay;
        for (PointerAction action : this.mActions) {
            if (time < action.duration) {
                return action.interpolate((float)time / (float)action.duration);
            }
            time -= action.duration;
        }
        return this.mActions.peekLast().end;
    }

    private static class PointerLinearMoveAction
    extends PointerAction {
        public PointerLinearMoveAction(Point startPoint, Point endPoint, int speed) {
            super(startPoint, endPoint, (long)(1000.0 * PointerLinearMoveAction.calcDistance(startPoint, endPoint) / (double)speed));
        }

        @Override
        public Point interpolate(float fraction) {
            Point ret = new Point(this.start);
            ret.offset((int)(fraction * (float)(this.end.x - this.start.x)), (int)(fraction * (float)(this.end.y - this.start.y)));
            return ret;
        }

        private static double calcDistance(Point a, Point b) {
            return Math.sqrt((b.x - a.x) * (b.x - a.x) + (b.y - a.y) * (b.y - a.y));
        }
    }

    private static class PointerPauseAction
    extends PointerAction {
        public PointerPauseAction(Point startPoint, long time) {
            super(startPoint, startPoint, time);
        }

        @Override
        public Point interpolate(float fraction) {
            return new Point(this.start);
        }
    }

    private static abstract class PointerAction {
        final Point start;
        final Point end;
        final long duration;

        public PointerAction(Point startPoint, Point endPoint, long time) {
            this.start = startPoint;
            this.end = endPoint;
            this.duration = time;
        }

        public abstract Point interpolate(float var1);
    }
}

