/*
 * Decompiled with CFR 0.152.
 */
package android.support.test.uiautomator;

import android.util.Log;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;

public class Tracer {
    private static final String UNKNOWN_METHOD_STRING = "(unknown method)";
    private static final String UIAUTOMATOR_PACKAGE = "android.support.test.uiautomator";
    private static final int CALLER_LOCATION = 6;
    private static final int METHOD_TO_TRACE_LOCATION = 5;
    private static final int MIN_STACK_TRACE_LENGTH = 7;
    private Mode mCurrentMode = Mode.NONE;
    private List<TracerSink> mSinks = new ArrayList<TracerSink>();
    private File mOutputFile;
    private static Tracer mInstance = null;

    public static Tracer getInstance() {
        if (mInstance == null) {
            mInstance = new Tracer();
        }
        return mInstance;
    }

    public void setOutputMode(Mode mode) {
        this.closeSinks();
        this.mCurrentMode = mode;
        try {
            switch (mode) {
                case FILE: {
                    if (this.mOutputFile == null) {
                        throw new IllegalArgumentException("Please provide a filename before attempting write trace to a file");
                    }
                    this.mSinks.add(new FileSink(this.mOutputFile));
                    break;
                }
                case LOGCAT: {
                    this.mSinks.add(new LogcatSink());
                    break;
                }
                case ALL: {
                    this.mSinks.add(new LogcatSink());
                    if (this.mOutputFile == null) {
                        throw new IllegalArgumentException("Please provide a filename before attempting write trace to a file");
                    }
                    this.mSinks.add(new FileSink(this.mOutputFile));
                    break;
                }
            }
        }
        catch (FileNotFoundException e) {
            Log.w((String)"Tracer", (String)("Could not open log file: " + e.getMessage()));
        }
    }

    private void closeSinks() {
        for (TracerSink sink : this.mSinks) {
            sink.close();
        }
        this.mSinks.clear();
    }

    public void setOutputFilename(String filename) {
        this.mOutputFile = new File(filename);
    }

    private void doTrace(Object[] arguments) {
        if (this.mCurrentMode == Mode.NONE) {
            return;
        }
        String caller = Tracer.getCaller();
        if (caller == null) {
            return;
        }
        this.log(String.format("%s (%s)", caller, Tracer.join(", ", arguments)));
    }

    private void log(String message) {
        for (TracerSink sink : this.mSinks) {
            sink.log(message);
        }
    }

    public boolean isTracingEnabled() {
        return this.mCurrentMode != Mode.NONE;
    }

    public static void trace(Object ... arguments) {
        Tracer.getInstance().doTrace(arguments);
    }

    private static String join(String separator, Object[] strings) {
        if (strings.length == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder(Tracer.objectToString(strings[0]));
        for (int i = 1; i < strings.length; ++i) {
            builder.append(separator);
            builder.append(Tracer.objectToString(strings[i]));
        }
        return builder.toString();
    }

    private static String objectToString(Object obj) {
        if (obj.getClass().isArray()) {
            if (obj instanceof Object[]) {
                return Arrays.deepToString((Object[])obj);
            }
            return "[...]";
        }
        return obj.toString();
    }

    private static String getCaller() {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        if (stackTrace.length < 7) {
            return UNKNOWN_METHOD_STRING;
        }
        StackTraceElement caller = stackTrace[5];
        StackTraceElement previousCaller = stackTrace[6];
        if (previousCaller.getClassName().startsWith(UIAUTOMATOR_PACKAGE)) {
            return null;
        }
        int indexOfDot = caller.getClassName().lastIndexOf(46);
        if (indexOfDot < 0) {
            indexOfDot = 0;
        }
        if (indexOfDot + 1 >= caller.getClassName().length()) {
            return UNKNOWN_METHOD_STRING;
        }
        String shortClassName = caller.getClassName().substring(indexOfDot + 1);
        return String.format("%s.%s from %s() at %s:%d", shortClassName, caller.getMethodName(), previousCaller.getMethodName(), previousCaller.getFileName(), previousCaller.getLineNumber());
    }

    private class LogcatSink
    implements TracerSink {
        private static final String LOGCAT_TAG = "UiAutomatorTrace";

        private LogcatSink() {
        }

        @Override
        public void log(String message) {
            Log.i((String)LOGCAT_TAG, (String)message);
        }

        @Override
        public void close() {
        }
    }

    private class FileSink
    implements TracerSink {
        private PrintWriter mOut;
        private SimpleDateFormat mDateFormat;

        public FileSink(File file) throws FileNotFoundException {
            this.mOut = new PrintWriter(file);
            this.mDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.US);
        }

        @Override
        public void log(String message) {
            this.mOut.printf("%s %s\n", this.mDateFormat.format(new Date()), message);
        }

        @Override
        public void close() {
            this.mOut.close();
        }
    }

    private static interface TracerSink {
        public void log(String var1);

        public void close();
    }

    public static enum Mode {
        NONE,
        FILE,
        LOGCAT,
        ALL;

    }
}

