/*
 * Decompiled with CFR 0.152.
 */
package android.support.test.uiautomator;

import android.content.Context;
import android.graphics.Point;
import android.graphics.Rect;
import android.os.Bundle;
import android.os.SystemClock;
import android.support.test.uiautomator.By;
import android.support.test.uiautomator.ByMatcher;
import android.support.test.uiautomator.BySelector;
import android.support.test.uiautomator.Direction;
import android.support.test.uiautomator.EventCondition;
import android.support.test.uiautomator.GestureController;
import android.support.test.uiautomator.Gestures;
import android.support.test.uiautomator.InteractionController;
import android.support.test.uiautomator.PointerGesture;
import android.support.test.uiautomator.SearchCondition;
import android.support.test.uiautomator.Searchable;
import android.support.test.uiautomator.StaleObjectException;
import android.support.test.uiautomator.UiDevice;
import android.support.test.uiautomator.UiObject2Condition;
import android.support.test.uiautomator.Until;
import android.support.test.uiautomator.WaitMixin;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.ViewConfiguration;
import android.view.accessibility.AccessibilityNodeInfo;
import java.util.ArrayList;
import java.util.List;

public class UiObject2
implements Searchable {
    private static final String TAG = UiObject2.class.getSimpleName();
    private UiDevice mDevice;
    private Gestures mGestures;
    private GestureController mGestureController;
    private BySelector mSelector;
    private AccessibilityNodeInfo mCachedNode;
    private DisplayMetrics mDisplayMetrics;
    private int mMarginLeft = 5;
    private int mMarginTop = 5;
    private int mMarginRight = 5;
    private int mMarginBottom = 5;
    private static final int DEFAULT_SWIPE_SPEED = 5000;
    private static final int DEFAULT_SCROLL_SPEED = 5000;
    private static final int DEFAULT_FLING_SPEED = 7500;
    private static final int DEFAULT_DRAG_SPEED = 2500;
    private static final int DEFAULT_PINCH_SPEED = 2500;
    private final long SCROLL_TIMEOUT = 1000L;
    private final long FLING_TIMEOUT = 5000L;
    private WaitMixin<UiObject2> mWaitMixin = new WaitMixin<UiObject2>(this);

    UiObject2(UiDevice device, BySelector selector, AccessibilityNodeInfo cachedNode) {
        this.mDevice = device;
        this.mSelector = selector;
        this.mCachedNode = cachedNode;
        this.mGestures = Gestures.getInstance(device);
        this.mGestureController = GestureController.getInstance(device);
        this.mDisplayMetrics = this.mDevice.getAutomatorBridge().getContext().getResources().getDisplayMetrics();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        try {
            UiObject2 other = (UiObject2)object;
            return this.getAccessibilityNodeInfo().equals((Object)other.getAccessibilityNodeInfo());
        }
        catch (StaleObjectException e) {
            return false;
        }
    }

    public int hashCode() {
        return this.getAccessibilityNodeInfo().hashCode();
    }

    public void recycle() {
        this.mCachedNode.recycle();
        this.mCachedNode = null;
    }

    public void setGestureMargin(int margin) {
        this.setGestureMargins(margin, margin, margin, margin);
    }

    public void setGestureMargins(int left, int top, int right, int bottom) {
        this.mMarginLeft = left;
        this.mMarginTop = top;
        this.mMarginRight = right;
        this.mMarginBottom = bottom;
    }

    public <R> R wait(UiObject2Condition<R> condition, long timeout) {
        return this.mWaitMixin.wait(condition, timeout);
    }

    public <R> R wait(SearchCondition<R> condition, long timeout) {
        return this.mWaitMixin.wait(condition, timeout);
    }

    public UiObject2 getParent() {
        AccessibilityNodeInfo parent = this.getAccessibilityNodeInfo().getParent();
        return parent != null ? new UiObject2(this.mDevice, this.mSelector, parent) : null;
    }

    public int getChildCount() {
        return this.getAccessibilityNodeInfo().getChildCount();
    }

    public List<UiObject2> getChildren() {
        return this.findObjects(By.depth(1));
    }

    @Override
    public boolean hasObject(BySelector selector) {
        AccessibilityNodeInfo node = ByMatcher.findMatch(this.mDevice, this.getAccessibilityNodeInfo(), selector);
        if (node != null) {
            node.recycle();
            return true;
        }
        return false;
    }

    @Override
    public UiObject2 findObject(BySelector selector) {
        AccessibilityNodeInfo node = ByMatcher.findMatch(this.mDevice, this.getAccessibilityNodeInfo(), selector);
        return node != null ? new UiObject2(this.mDevice, selector, node) : null;
    }

    @Override
    public List<UiObject2> findObjects(BySelector selector) {
        ArrayList<UiObject2> ret = new ArrayList<UiObject2>();
        for (AccessibilityNodeInfo node : ByMatcher.findMatches(this.mDevice, this.getAccessibilityNodeInfo(), selector)) {
            ret.add(new UiObject2(this.mDevice, selector, node));
        }
        return ret;
    }

    public Rect getVisibleBounds() {
        return this.getVisibleBounds(this.getAccessibilityNodeInfo());
    }

    private Rect getVisibleBoundsForGestures() {
        Rect ret = this.getVisibleBounds();
        ret.left += this.mMarginLeft;
        ret.top += this.mMarginTop;
        ret.right -= this.mMarginRight;
        ret.bottom -= this.mMarginBottom;
        return ret;
    }

    private Rect getVisibleBounds(AccessibilityNodeInfo node) {
        Rect ret = new Rect();
        node.getBoundsInScreen(ret);
        Rect screen = new Rect(0, 0, this.mDevice.getDisplayWidth(), this.mDevice.getDisplayHeight());
        ret.intersect(screen);
        AccessibilityNodeInfo ancestor = null;
        for (ancestor = node.getParent(); ancestor != null; ancestor = ancestor.getParent()) {
            if (!ancestor.isScrollable()) continue;
            Rect ancestorRect = this.getVisibleBounds(ancestor);
            ret.intersect(ancestorRect);
            break;
        }
        return ret;
    }

    public Point getVisibleCenter() {
        Rect bounds = this.getVisibleBounds();
        return new Point(bounds.centerX(), bounds.centerY());
    }

    public String getClassName() {
        CharSequence chars = this.getAccessibilityNodeInfo().getClassName();
        return chars != null ? chars.toString() : null;
    }

    public String getContentDescription() {
        CharSequence chars = this.getAccessibilityNodeInfo().getContentDescription();
        return chars != null ? chars.toString() : null;
    }

    public String getApplicationPackage() {
        CharSequence chars = this.getAccessibilityNodeInfo().getPackageName();
        return chars != null ? chars.toString() : null;
    }

    public String getResourceName() {
        String chars = this.getAccessibilityNodeInfo().getViewIdResourceName();
        return chars != null ? chars.toString() : null;
    }

    public String getText() {
        CharSequence chars = this.getAccessibilityNodeInfo().getText();
        return chars != null ? chars.toString() : null;
    }

    public boolean isCheckable() {
        return this.getAccessibilityNodeInfo().isCheckable();
    }

    public boolean isChecked() {
        return this.getAccessibilityNodeInfo().isChecked();
    }

    public boolean isClickable() {
        return this.getAccessibilityNodeInfo().isClickable();
    }

    public boolean isEnabled() {
        return this.getAccessibilityNodeInfo().isEnabled();
    }

    public boolean isFocusable() {
        return this.getAccessibilityNodeInfo().isFocusable();
    }

    public boolean isFocused() {
        return this.getAccessibilityNodeInfo().isFocused();
    }

    public boolean isLongClickable() {
        return this.getAccessibilityNodeInfo().isLongClickable();
    }

    public boolean isScrollable() {
        return this.getAccessibilityNodeInfo().isScrollable();
    }

    public boolean isSelected() {
        return this.getAccessibilityNodeInfo().isSelected();
    }

    public void clear() {
        this.setText("");
    }

    public void click() {
        this.mGestureController.performGesture(this.mGestures.click(this.getVisibleCenter()));
    }

    public <R> R clickAndWait(EventCondition<R> condition, long timeout) {
        return this.mGestureController.performGestureAndWait(condition, timeout, this.mGestures.click(this.getVisibleCenter()));
    }

    public void drag(Point dest) {
        this.drag(dest, (int)(2500.0f * this.mDisplayMetrics.density));
    }

    public void drag(Point dest, int speed) {
        if (speed < 0) {
            throw new IllegalArgumentException("Speed cannot be negative");
        }
        this.mGestureController.performGesture(this.mGestures.drag(this.getVisibleCenter(), dest, speed));
    }

    public void longClick() {
        this.mGestureController.performGesture(this.mGestures.longClick(this.getVisibleCenter()));
    }

    public void pinchClose(float percent) {
        this.pinchClose(percent, (int)(2500.0f * this.mDisplayMetrics.density));
    }

    public void pinchClose(float percent, int speed) {
        if (percent < 0.0f || percent > 1.0f) {
            throw new IllegalArgumentException("Percent must be between 0.0f and 1.0f");
        }
        if (speed < 0) {
            throw new IllegalArgumentException("Speed cannot be negative");
        }
        this.mGestureController.performGesture(this.mGestures.pinchClose(this.getVisibleBoundsForGestures(), percent, speed));
    }

    public void pinchOpen(float percent) {
        this.pinchOpen(percent, (int)(2500.0f * this.mDisplayMetrics.density));
    }

    public void pinchOpen(float percent, int speed) {
        if (percent < 0.0f || percent > 1.0f) {
            throw new IllegalArgumentException("Percent must be between 0.0f and 1.0f");
        }
        if (speed < 0) {
            throw new IllegalArgumentException("Speed cannot be negative");
        }
        this.mGestureController.performGesture(this.mGestures.pinchOpen(this.getVisibleBoundsForGestures(), percent, speed));
    }

    public void swipe(Direction direction, float percent) {
        this.swipe(direction, percent, (int)(5000.0f * this.mDisplayMetrics.density));
    }

    public void swipe(Direction direction, float percent, int speed) {
        if (percent < 0.0f || percent > 1.0f) {
            throw new IllegalArgumentException("Percent must be between 0.0f and 1.0f");
        }
        if (speed < 0) {
            throw new IllegalArgumentException("Speed cannot be negative");
        }
        Rect bounds = this.getVisibleBoundsForGestures();
        this.mGestureController.performGesture(this.mGestures.swipeRect(bounds, direction, percent, speed));
    }

    public boolean scroll(Direction direction, float percent) {
        return this.scroll(direction, percent, (int)(5000.0f * this.mDisplayMetrics.density));
    }

    public boolean scroll(Direction direction, float percent, int speed) {
        if (percent < 0.0f) {
            throw new IllegalArgumentException("Percent must be greater than 0.0f");
        }
        if (speed < 0) {
            throw new IllegalArgumentException("Speed cannot be negative");
        }
        Direction swipeDirection = Direction.reverse(direction);
        Rect bounds = this.getVisibleBoundsForGestures();
        while (percent > 0.0f) {
            float segment = percent > 1.0f ? 1.0f : percent;
            PointerGesture swipe = this.mGestures.swipeRect(bounds, swipeDirection, segment, speed).pause(250L);
            if (this.mGestureController.performGestureAndWait(Until.scrollFinished(direction), 1000L, swipe).booleanValue()) {
                return false;
            }
            percent -= 1.0f;
        }
        return true;
    }

    public boolean fling(Direction direction) {
        return this.fling(direction, (int)(7500.0f * this.mDisplayMetrics.density));
    }

    public boolean fling(Direction direction, int speed) {
        ViewConfiguration vc = ViewConfiguration.get((Context)this.mDevice.getAutomatorBridge().getContext());
        if (speed < vc.getScaledMinimumFlingVelocity()) {
            throw new IllegalArgumentException("Speed is less than the minimum fling velocity");
        }
        Direction swipeDirection = Direction.reverse(direction);
        Rect bounds = this.getVisibleBoundsForGestures();
        PointerGesture swipe = this.mGestures.swipeRect(bounds, swipeDirection, 1.0f, speed);
        return this.mGestureController.performGestureAndWait(Until.scrollFinished(direction), 5000L, swipe) == false;
    }

    public void legacySetText(String text) {
        CharSequence currentText;
        AccessibilityNodeInfo node = this.getAccessibilityNodeInfo();
        if (text == null) {
            text = "";
        }
        if (!text.equals(currentText = node.getText())) {
            InteractionController ic = this.mDevice.getAutomatorBridge().getInteractionController();
            Rect rect = this.getVisibleBounds();
            ic.longTapNoSync(rect.left + 20, rect.centerY());
            this.mDevice.wait(Until.findObject(By.descContains("Select all")), 50L).click();
            SystemClock.sleep((long)250L);
            ic.sendKey(67, 0);
            ic.sendText(text);
        }
    }

    public void setText(String text) {
        AccessibilityNodeInfo node = this.getAccessibilityNodeInfo();
        if (text == null) {
            text = "";
        }
        if (UiDevice.API_LEVEL_ACTUAL > 19) {
            Bundle args = new Bundle();
            args.putCharSequence("ACTION_ARGUMENT_SET_TEXT_CHARSEQUENCE", (CharSequence)text);
            if (!node.performAction(0x200000, args)) {
                Log.w((String)TAG, (String)"AccessibilityNodeInfo#performAction(ACTION_SET_TEXT) failed");
            }
        } else {
            CharSequence currentText = node.getText();
            if (!text.equals(currentText)) {
                if (!node.performAction(1) && !node.isFocused()) {
                    Log.w((String)TAG, (String)"AccessibilityNodeInfo#performAction(ACTION_FOCUS) failed");
                }
                Bundle args = new Bundle();
                args.putInt("ACTION_ARGUMENT_SELECTION_START_INT", 0);
                args.putInt("ACTION_ARGUMENT_SELECTION_END_INT", text.length());
                if (!node.performAction(131072, args) && currentText.length() > 0) {
                    Log.w((String)TAG, (String)"AccessibilityNodeInfo#performAction(ACTION_SET_SELECTION) failed");
                }
                InteractionController ic = this.mDevice.getAutomatorBridge().getInteractionController();
                ic.sendKey(67, 0);
                ic.sendText(text);
            }
        }
    }

    private AccessibilityNodeInfo getAccessibilityNodeInfo() {
        if (this.mCachedNode == null) {
            throw new IllegalStateException("This object has already been recycled");
        }
        if (!this.mCachedNode.refresh()) {
            this.mDevice.runWatchers();
            if (!this.mCachedNode.refresh()) {
                throw new StaleObjectException();
            }
        }
        return this.mCachedNode;
    }
}

