/*
 * Decompiled with CFR 0.152.
 */
package android.support.test.espresso.intent;

import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.os.Bundle;
import android.support.test.espresso.intent.Checks;
import android.support.test.espresso.intent.ResolvedIntent;
import java.util.ArrayList;
import java.util.List;

class ResolvedIntentImpl
extends Intent
implements ResolvedIntent {
    private final List<ResolveInfo> possibleResolutions;

    ResolvedIntentImpl(Intent intent, List<ResolveInfo> possibleResolutions) {
        super(Checks.checkNotNull(intent));
        this.possibleResolutions = Checks.checkNotNull(possibleResolutions);
    }

    @Override
    public final boolean canBeHandledBy(String appPackage) {
        Checks.checkNotNull(appPackage);
        for (String pkg : this.getPossibleResolutionPackages()) {
            if (!appPackage.equals(pkg)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Intent getIntent() {
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("%s handling packages:[%s]", super.toString(), this.getPossibleResolutionPackages()));
        Bundle extrasBundle = this.getExtras();
        if (extrasBundle != null) {
            sb.append(String.format(", extras:[%s]", extrasBundle.toString()));
        }
        return sb.toString();
    }

    private List<String> getPossibleResolutionPackages() {
        ArrayList<String> packages = new ArrayList<String>();
        for (ResolveInfo info : this.possibleResolutions) {
            packages.add(info.activityInfo.packageName);
        }
        return packages;
    }
}

