/*
 * Decompiled with CFR 0.152.
 */
package android.support.test.internal.runner.junit4;

import android.support.test.internal.util.AndroidRunnerParams;
import android.support.test.runner.AndroidJUnit4;
import org.junit.internal.builders.AnnotatedBuilder;
import org.junit.runner.RunWith;
import org.junit.runner.Runner;
import org.junit.runners.model.RunnerBuilder;

public class AndroidAnnotatedBuilder
extends AnnotatedBuilder {
    private static final String LOG_TAG = "AndroidAnnotatedBuilder";
    private final AndroidRunnerParams mAndroidRunnerParams;

    public AndroidAnnotatedBuilder(RunnerBuilder suiteBuilder, AndroidRunnerParams runnerParams) {
        super(suiteBuilder);
        this.mAndroidRunnerParams = runnerParams;
    }

    public Runner runnerForClass(Class<?> testClass) throws Exception {
        Runner runner;
        RunWith annotation = testClass.getAnnotation(RunWith.class);
        if (annotation != null && annotation.value().equals(AndroidJUnit4.class) && (runner = this.buildAndroidRunner(annotation.value(), testClass)) != null) {
            return runner;
        }
        return super.runnerForClass(testClass);
    }

    public Runner buildAndroidRunner(Class<? extends Runner> runnerClass, Class<?> testClass) throws Exception {
        try {
            return runnerClass.getConstructor(Class.class, AndroidRunnerParams.class).newInstance(testClass, this.mAndroidRunnerParams);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }
}

