/*
 * Decompiled with CFR 0.152.
 */
package android.support.test.internal.runner.lifecycle;

import android.app.Application;
import android.support.test.internal.util.Checks;
import android.support.test.runner.lifecycle.ApplicationLifecycleCallback;
import android.support.test.runner.lifecycle.ApplicationLifecycleMonitor;
import android.support.test.runner.lifecycle.ApplicationStage;
import android.util.Log;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ApplicationLifecycleMonitorImpl
implements ApplicationLifecycleMonitor {
    private static final String TAG = "ApplicationLifecycleMonitorImpl";
    private List<WeakReference<ApplicationLifecycleCallback>> mCallbacks = new ArrayList<WeakReference<ApplicationLifecycleCallback>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLifecycleCallback(ApplicationLifecycleCallback callback) {
        Checks.checkNotNull(callback);
        List<WeakReference<ApplicationLifecycleCallback>> list = this.mCallbacks;
        synchronized (list) {
            boolean needsAdd = true;
            Iterator<WeakReference<ApplicationLifecycleCallback>> refIter = this.mCallbacks.iterator();
            while (refIter.hasNext()) {
                ApplicationLifecycleCallback storedCallback = (ApplicationLifecycleCallback)refIter.next().get();
                if (null == storedCallback) {
                    refIter.remove();
                    continue;
                }
                if (storedCallback != callback) continue;
                needsAdd = false;
            }
            if (needsAdd) {
                this.mCallbacks.add(new WeakReference<ApplicationLifecycleCallback>(callback));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeLifecycleCallback(ApplicationLifecycleCallback callback) {
        Checks.checkNotNull(callback);
        List<WeakReference<ApplicationLifecycleCallback>> list = this.mCallbacks;
        synchronized (list) {
            Iterator<WeakReference<ApplicationLifecycleCallback>> refIter = this.mCallbacks.iterator();
            while (refIter.hasNext()) {
                ApplicationLifecycleCallback storedCallback = (ApplicationLifecycleCallback)refIter.next().get();
                if (null == storedCallback) {
                    refIter.remove();
                    continue;
                }
                if (storedCallback != callback) continue;
                refIter.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void signalLifecycleChange(Application app, ApplicationStage stage) {
        List<WeakReference<ApplicationLifecycleCallback>> list = this.mCallbacks;
        synchronized (list) {
            Iterator<WeakReference<ApplicationLifecycleCallback>> refIter = this.mCallbacks.iterator();
            while (refIter.hasNext()) {
                ApplicationLifecycleCallback callback = (ApplicationLifecycleCallback)refIter.next().get();
                if (null == callback) {
                    refIter.remove();
                    continue;
                }
                try {
                    Log.d((String)TAG, (String)("running callback: " + callback));
                    callback.onApplicationLifecycleChanged(app, stage);
                    Log.d((String)TAG, (String)("callback completes: " + callback));
                }
                catch (RuntimeException re) {
                    Log.e((String)TAG, (String)String.format("Callback threw exception! (callback: %s stage: %s)", new Object[]{callback, stage}), (Throwable)re);
                }
            }
        }
    }
}

