/*
 * Decompiled with CFR 0.152.
 */
package android.support.test.espresso.contrib;

import android.support.test.espresso.UiController;
import android.support.test.espresso.ViewAction;
import android.support.test.espresso.matcher.ViewMatchers;
import android.view.View;
import android.widget.DatePicker;
import android.widget.TimePicker;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public final class PickerActions {
    private PickerActions() {
    }

    public static ViewAction setDate(final int year, int monthOfYear, final int dayOfMonth) {
        final int normalizedMonthOfYear = monthOfYear - 1;
        return new ViewAction(){

            public void perform(UiController uiController, View view) {
                DatePicker datePicker = (DatePicker)view;
                datePicker.updateDate(year, normalizedMonthOfYear, dayOfMonth);
            }

            public String getDescription() {
                return "set date";
            }

            public Matcher<View> getConstraints() {
                return Matchers.allOf((Matcher)ViewMatchers.isAssignableFrom(DatePicker.class), (Matcher)ViewMatchers.isDisplayed());
            }
        };
    }

    public static ViewAction setTime(final int hours, final int minutes) {
        return new ViewAction(){

            public void perform(UiController uiController, View view) {
                TimePicker timePicker = (TimePicker)view;
                timePicker.setCurrentHour(Integer.valueOf(hours));
                timePicker.setCurrentMinute(Integer.valueOf(minutes));
            }

            public String getDescription() {
                return "set time";
            }

            public Matcher<View> getConstraints() {
                return Matchers.allOf((Matcher)ViewMatchers.isAssignableFrom(TimePicker.class), (Matcher)ViewMatchers.isDisplayed());
            }
        };
    }
}

