/*
 * Decompiled with CFR 0.152.
 */
package android.support.test.internal.runner.listener;

import android.support.test.internal.runner.listener.InstrumentationRunListener;
import android.test.suitebuilder.annotation.LargeTest;
import android.test.suitebuilder.annotation.MediumTest;
import android.test.suitebuilder.annotation.SmallTest;
import android.util.Log;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;

public class SuiteAssignmentPrinter
extends InstrumentationRunListener {
    private static final float SMALL_SUITE_MAX_RUNTIME = 200.0f;
    private static final float MEDIUM_SUITE_MAX_RUNTIME = 1000.0f;
    private long mStartTime;
    private boolean mTimingValid;

    public void testStarted(Description description) throws Exception {
        this.mTimingValid = true;
        this.mStartTime = System.currentTimeMillis();
    }

    public void testFinished(Description description) throws Exception {
        long endTime = System.currentTimeMillis();
        if (!this.mTimingValid || this.mStartTime < 0L) {
            String assignmentSuite = "NA";
            long runTime = -1L;
            this.sendString("F");
            Log.d((String)"SuiteAssignmentPrinter", (String)String.format("%s#%s: skipping suite assignment due to test failure\n", description.getClassName(), description.getMethodName()));
        } else {
            String currentSize;
            long runTime = endTime - this.mStartTime;
            String assignmentSuite = (float)runTime < 200.0f ? "small" : ((float)runTime < 1000.0f ? "medium" : "large");
            if (!assignmentSuite.equals(currentSize = this.getTestSize(description))) {
                this.sendString(String.format("\n%s#%s: current size: %s. suggested: %s runTime: %d ms\n", description.getClassName(), description.getMethodName(), currentSize, assignmentSuite, runTime));
            } else {
                this.sendString(".");
                Log.d((String)"SuiteAssignmentPrinter", (String)String.format("%s#%s assigned correctly as %s. runTime: %d ms\n", description.getClassName(), description.getMethodName(), assignmentSuite, runTime));
            }
        }
        this.mStartTime = -1L;
    }

    private String getTestSize(Description description) {
        String testSize = this.getTestSizeFromMethod(description);
        if (testSize != null) {
            return testSize;
        }
        return this.getTestSizeFromClass(description);
    }

    String getTestSizeFromMethod(Description desc) {
        if (desc.getAnnotation(SmallTest.class) != null) {
            return "small";
        }
        if (desc.getAnnotation(MediumTest.class) != null) {
            return "medium";
        }
        if (desc.getAnnotation(LargeTest.class) != null) {
            return "large";
        }
        return null;
    }

    String getTestSizeFromClass(Description desc) {
        Class testClass = desc.getTestClass();
        if (testClass == null) {
            return null;
        }
        if (testClass.isAnnotationPresent(SmallTest.class)) {
            return "small";
        }
        if (testClass.isAnnotationPresent(MediumTest.class)) {
            return "medium";
        }
        if (testClass.isAnnotationPresent(LargeTest.class)) {
            return "large";
        }
        return null;
    }

    public void testFailure(Failure failure) throws Exception {
        this.mTimingValid = false;
    }

    public void testAssumptionFailure(Failure failure) {
        this.mTimingValid = false;
    }

    public void testIgnored(Description description) throws Exception {
        this.mTimingValid = false;
    }
}

