# How to become a contributor and submit your own code

To contribute with a small fix, simply create a pull request. If you want to add a new sample or plan to request a big change, [contact us](https://groups.google.com/forum/#!forum/android-testing-support-library) first.

## Contributing new samples

If you want to contribute full samples, we'd love to review and accept them. In case you need ideas, these are some samples on the roadmap:

* Advanced Idling Resource 
* RecyclerView actions
* Sharding 
* RunListener 
* Rules
 
You can also contribute to this list if you have a sample request.

## Code style and structure

Please check out the [Code Style for Contributors](https://source.android.com/source/code-style.html) section in AOSP. Also, check out the rest of the samples and maintain as much consistency with them as possible.

## Contributor License Agreements

We'd love to accept your sample apps and patches! Before we can take them, we
have to jump a couple of legal hurdles.

Please fill out either the individual or corporate Contributor License Agreement (CLA).

  * If you are an individual writing original source code and you're sure you
    own the intellectual property, then you'll need to sign an [individual CLA]
    (https://cla.developers.google.com).
  * If you work for a company that wants to allow you to contribute your work,
    then you'll need to sign a [corporate CLA]
    (https://cla.developers.google.com).
  * Please make sure you sign both, Android and Google CLA

Follow either of the two links above to access the appropriate CLA and
instructions for how to sign and return it. Once we receive it, we'll be able to
accept your pull requests.

## Contributing A Patch

1. Submit an issue describing your proposed change to the repo in question.
1. The repo owner will respond to your issue promptly.
1. If your proposed change is accepted, and you haven't already done so, sign a
   Contributor License Agreement (see details above).
1. Fork the desired repo, develop and test your code changes.
1. Ensure that your code adheres to the existing style in the sample to which
   you are contributing. Refer to the
   [Android Code Style Guide]
   (https://source.android.com/source/code-style.html) for the
   recommended coding standards for this organization.
1. Ensure that your code has an appropriate set of unit tests which all pass.
1. Submit a pull request.
